package com.jiejing.fitness.finance.app.controller.cashier;

import com.jiejing.common.model.JsonResult;
import com.jiejing.common.model.PageVO;
import com.jiejing.common.utils.convert.BeanUtil;
import com.jiejing.fitness.finance.api.cashier.BrandCashierApi;
import com.jiejing.fitness.finance.api.cashier.request.GetBrandCashierByIdRequest;
import com.jiejing.fitness.finance.api.cashier.request.ListBrandCashierByOrderNoRequest;
import com.jiejing.fitness.finance.api.cashier.request.PageBrandCashierRequest;
import com.jiejing.fitness.finance.api.cashier.vo.BrandCashierRecordVO;
import com.jiejing.fitness.finance.service.cashier.BrandCashierService;
import com.jiejing.fitness.finance.service.cashier.params.PageBrandCashierParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author chengyubing
 * @since 2024/2/29 10:41
 */
@RestController
public class BrandCashierController implements BrandCashierApi {

  @Resource
  private BrandCashierService brandCashierService;

  @ApiOperation(value = "分页筛选收银流水", tags = {TAG})
  @PostMapping(value = "/private/brandCashier/page")
  @Override
  public JsonResult<PageVO<BrandCashierRecordVO>> page(@Valid @RequestBody PageBrandCashierRequest request) {
    PageBrandCashierParams params = BeanUtil.map(request, PageBrandCashierParams.class);
    return JsonResult.success(brandCashierService.page(params));
  }

  @ApiOperation(value = "查询收银流水详情", tags = {TAG})
  @PostMapping(value = "/private/brandCashier/getById")
  @Override
  public JsonResult<BrandCashierRecordVO> getById(@Valid @RequestBody GetBrandCashierByIdRequest request) {
    return JsonResult.success(brandCashierService.getById(request.getId()));
  }

  @ApiOperation(value = "根据订单号查询收银列表", tags = {TAG})
  @PostMapping(value = "/private/brandCashier/listByOrderNo")
  @Override
  public JsonResult<List<BrandCashierRecordVO>> listByOrderNo(
      @Valid @RequestBody ListBrandCashierByOrderNoRequest request) {
    return JsonResult.success(brandCashierService.listByOrderNo(request.getOrderNo()));
  }

}
