package com.jiejing.fitness.finance.repository;

import static com.jiejing.mbp.utils.CodeGenerateTypeEnum.ENTITY;
import static com.jiejing.mbp.utils.CodeGenerateTypeEnum.MAPPER_INTERFACE;
import static com.jiejing.mbp.utils.CodeGenerateTypeEnum.MAPPER_XML;
import static com.jiejing.mbp.utils.CodeGenerateTypeEnum.SERVICE;

import com.google.common.collect.Sets;
import com.jiejing.mbp.utils.CodeGenerateTypeEnum;
import com.jiejing.mbp.utils.CodeGenerateUtil;
import java.util.Set;
import org.junit.Test;

/**
 * <p>
 * 测试生成代码
 * </p>
 *
 * @author K神
 * @date 2017/12/18
 */
public class GeneratorServiceEntity {

  /**
   * 数据库连接配置
   * <p>
   * 需要换成对应的数据库
   */
  private static final String dbUrl = "jdbc:mysql://rm-bp1jio2v5y2msvh6jno.rwlb.rds.aliyuncs.com/"
      + "finance"
      + "?useUnicode=true&characterEncoding=utf-8&useSSL=false";
  private static final String userName = "root";
  private static final String password = "4rfv%TGB";

  /**
   * 需要换成对应包名
   */
  private static final String packageName = "com.jiejing.fitness.finance.repository";
  private static final String outPutDir = "../repository/src/main/java";

  private Set<CodeGenerateTypeEnum> generateAll = Sets
      .newHashSet(ENTITY, MAPPER_XML, MAPPER_INTERFACE, SERVICE);
  private Set<CodeGenerateTypeEnum> generateEntity = Sets.newHashSet(MAPPER_XML);

  /**
   * 是否覆盖原有代码文件，按需设置
   */
  private Boolean fileOverride = true;
  /**
   * 使用前请更改
   */
  private String author = "chengyubing";
  private String[] tableNames = {
//      "global_config",
//      "studio_merchant_apply",
//      "party_to_merchant",
//      "brand_cashier_record"
  };

  /**
   * 使用前确认包含jar包
   * <dependency>
   * <groupId>com.baomidou</groupId>
   * <artifactId>mybatis-plus-generator</artifactId>
   * <version>3.1.0</version>
   * <scope>test</scope>
   * </dependency>
   */
  @Test
  public void generateAllCode() {
    CodeGenerateUtil
        .generateByTableNames(dbUrl, userName, password, outPutDir, packageName, generateAll,
            fileOverride, author, tableNames);
  }

  @Test
  public void generateOnlyEntity() {
    CodeGenerateUtil
        .generateByTableNames(dbUrl, userName, password, outPutDir, packageName, generateEntity,
            fileOverride, author, tableNames);
  }

}
