package com.jiejing.fitness.finance.service.cashier.impl;

import com.jiejing.common.model.PageVO;
import com.jiejing.common.utils.convert.BeanUtil;
import com.jiejing.fitness.finance.api.cashier.vo.BrandCashierRecordVO;
import com.jiejing.fitness.finance.repository.entity.BrandCashierRecord;
import com.jiejing.fitness.finance.repository.query.PageBrandCashierRecordQuery;
import com.jiejing.fitness.finance.repository.service.BrandCashierRecordRpService;
import com.jiejing.fitness.finance.service.cashier.BrandCashierService;
import com.jiejing.fitness.finance.service.cashier.convert.CashierConvert;
import com.jiejing.fitness.finance.service.cashier.params.PageBrandCashierParams;
import java.util.List;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

/**
 * @author chengyubing
 * @since 2024/2/29 11:08
 */
@Slf4j
@Service
public class BrandCashierServiceImpl implements BrandCashierService {

  @Resource
  private BrandCashierRecordRpService brandCashierRecordRpService;

  @Override
  public BrandCashierRecordVO getById(Long id) {
    BrandCashierRecord record = brandCashierRecordRpService.getById(id).orElse(null);
    if (null == record) {
      return null;
    }
    return CashierConvert.convertVO(record);
  }

  @Override
  public List<BrandCashierRecordVO> listByOrderNo(String orderNo) {
    List<BrandCashierRecord> list = brandCashierRecordRpService.listByOrderNo(orderNo);
    return CashierConvert.convertList(list);
  }

  @Override
  public PageVO<BrandCashierRecordVO> page(PageBrandCashierParams params) {
    PageBrandCashierRecordQuery query = BeanUtil.map(params, PageBrandCashierRecordQuery.class);
    Page<BrandCashierRecord> page = brandCashierRecordRpService.page(query);
    return CashierConvert.convertPageVO(page);
  }
}
