/*
 * @Author: liguokang
 * @Date: 2021-07-14 20:36:28
 * @LastEditors: liguokang
 * @LastEditTime: 2021-07-15 10:25:37
 * @Description:
 * @Copyrigh: ©2021 杭州杰竞科技有限公司 版权所有
 */

import Link from 'next/link';
import { useEffect } from 'react';
import lottie from 'lottie-web';
import './Footer.less';
interface FooterProps {
  isTrial?: boolean;
}

export default function Footer(props: FooterProps) {
  useEffect(() => {
    if (props.isTrial) {
      generateAnimation();
    }
  }, []);

  // 生成动画
  function generateAnimation() {
    lottie.loadAnimation({
      container: document.getElementById('big-img-svg'),
      path: 'https://image.xiaomaiketang.com/xm/JPpibc4xdD.json',
      renderer: 'svg',
      loop: true,
      autoplay: true,
      name: 'Hello World',
    });
  }

  return (
    <footer>
      {props.isTrial && (
        <div className="content-module content-module-8">
          <div className="module-model">
            <div className="center">
              <div className="big-img" id="big-img-4">
                <div className="big-img-svg" id="big-img-svg">
                  <div className="wrap">
                    <div className="text">体验教育信息化新模式</div>
                    <div className="module-img">
                      <span className="btn-wrap">
                        <div
                          className="btn-click free-trial"
                          id="btn-free-try"
                          onClick={() => {
                            // window.WEBTRACING('WebG_foot_clickEvent_clickFreeUse', 'WebG_页面底部_点击事件_点击免费试用', { page: this.props.page })
                            this.renderModal(true);
                          }}
                        >
                          免费试用
                        </div>
                      </span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      )}
      <div className="center">
        <div className="footer-middle">
          <ul>
            <li className="item">
              <p>产品</p>
              <div className="fl">
                <Link href="/xmErp">
                  <span>小麦助教</span>
                </Link>
                <Link href="/cloud-class">
                  <span>云课堂</span>
                </Link>
                <Link href="/xm-school-info">
                  <span>小麦校讯通</span>
                </Link>
                <Link href="/micro-brand-web">
                  <span>微官网</span>
                </Link>
              </div>
              <div className="fr" style={{ marginLeft: '30px' }}>
                <Link href="/xm-show">
                  <span>小麦秀</span>
                </Link>
                <Link href="/mm-checkIn">
                  <span>麦麦打卡</span>
                </Link>
                <Link href="/mm-poster">
                  <span>麦萌海报</span>
                </Link>
                <Link href="/mm-chain">
                  <span>小麦连锁版</span>
                </Link>
              </div>
            </li>

            <li className="item">
              <p>招商加盟</p>
              <Link href="/wheat-system">
                <span>小麦助教系统</span>
              </Link>
            </li>

            <li className="item">
              <p>关于我们</p>
              <Link href="/company-profile">
                <span>公司简介</span>
              </Link>
              <Link href="/honorary-certificate">
                <span>荣誉资质</span>
              </Link>
              <Link href="/new-dynamic">
                <span>新闻动态</span>
              </Link>
              <Link href="/join-us">
                <span>加入我们</span>
              </Link>
              <a href="https://image.xiaomaiketang.com/xm/XGSwRGwacP.pdf" target="_blank" rel="noopener noreferrer">
                <span>隐私声明</span>
              </a>
            </li>

            <li className="item">
              <p>联系我们</p>
              <span>咨询电话：400-6677-456</span>
              <span>联系地址 : 杭州市西湖区古墩路598号同人广场A座3楼</span>
            </li>
            <li className="item">
              <div className="img">
                <div className="img1"></div>
              </div>
              <span>小麦助教公众号</span>
            </li>

            <li className="item">
              <div className="img">
                <div className="img2"></div>
              </div>
              <span>下载小麦助教</span>
            </li>
          </ul>
        </div>
        <div className="footer-bottom">
          <p>
            ©2015-2021&nbsp;&nbsp;杭州杰竞科技有限公司&nbsp;&nbsp;&nbsp;&nbsp;
            <a target="_blank" rel="noopener noreferrer" href="http://www.beian.gov.cn/portal/registerSystemInfo?recordcode=33010602006090">
              &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
              <img
                src="https://image.xiaomaiketang.com/xm/6mH2HnzP3k.png"
                alt=""
                style={{
                  width: '16px',
                  height: '16px',
                  display: 'inline-block',
                  margin: '0 4px 0 0',
                  verticalAlign: '-3px',
                }}
              />
              浙公网安备33010602006090号
            </a>
            &nbsp;&nbsp;&nbsp;&nbsp;
            <a style={{ marginLeft: '20px' }} target="_blank" rel="noopener noreferrer" href="https://beian.miit.gov.cn/#/Integrated/index">
              浙ICP备15025826号-2
            </a>
            &nbsp;&nbsp;&nbsp;&nbsp;
            <a style={{ marginLeft: '20px' }} target="_blank" rel="noopener noreferrer" href="https://image.xiaomaiketang.com/xm/ffXeG5fXn8.jpg">
              增值电信业务经营许可证：浙B2-20180802
            </a>
          </p>
          <p>
            <span style={{ marginLeft: '20px' }}>教APP备3300311号</span>
            &nbsp;&nbsp;&nbsp;&nbsp;
            <span style={{ marginLeft: '20px' }}>教APP备3300313号</span>
            &nbsp;&nbsp;&nbsp;&nbsp;
            <span style={{ marginLeft: '20px' }}>教APP备3300315号</span>
          </p>
        </div>
      </div>
    </footer>
  );
}
