/*
 * @Author: liguokang
 * @Date: 2021-07-14 20:42:36
 * @LastEditors: liguokang
 * @LastEditTime: 2021-07-15 10:23:15
 * @Description:  
 * @Copyrigh: ©2021 杭州杰竞科技有限公司 版权所有
 */

const fs = require('fs')
const [
  messageFile,
  commitType,
] = process.env.HUSKY_GIT_PARAMS.split(' ');

if (commitType == null) {
  const currentMessage = fs.readFileSync(messageFile, 'utf8');
  // eslint-disable-next-line no-console
  const pattern = new RegExp('(feat|fix|style|docs|refactor|pref|test):');
  const _currentMessage = currentMessage.replace('\n', '');
  if (!pattern.test(currentMessage) && currentMessage.indexOf('Merge branch') === -1) {
    // eslint-disable-next-line no-console
    console.error(`\x1b[31m ${_currentMessage}不符合commit-msg规范，具体规范请访问 http://wiki.ixm5.cn/pages/viewpage.action?pageId=2918494 \x1b[31m`);
    process.exit(1);
  }

  if (_currentMessage.length <= 10) {
    // eslint-disable-next-line no-console
    console.error(`\x1b[31m ${_currentMessage}提交的信息字数不得少于5个字符`);
    process.exit(1);
  }

  process.exit(0);
}
