/*
 * @Description:
 * @Author: zangsuyun
 * @Date: 2020-07-22 14:52:25
 * @LastEditors: zhujiapeng
 * @LastEditTime: 2021-06-04 11:39:10
 * @Copyright: © 2020 杭州杰竞科技有限公司 版权所有
 */

import React, { Component } from "react";
import Link from 'next/link';
import "./Header.less";
// import FreeTrial from "@/components/FreeTrial";

class Header extends Component {
  constructor(props) {
    super(props);
    this.state = {
      active: "home",
      isShow: false,
    };
  }
  //在componentDidMount生命周期中添加window的handleScroll滑动监听事件
  componentDidMount() {
    window.addEventListener("scroll", this.handleScroll);
    this.setState({
      active: this.props.active,
    });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }
  //定义handleScroll事件函数
  handleScroll = (e) => {
    var header = document.getElementById("header"); //定义一个dom节点为'header'的header变量
    if (window.pageYOffset >= 20) {
      //if语句判断window页面Y方向的位移是否大于或者等于导航栏的height像素值
      header && header.classList.add("header_bg"); //当Y方向位移大于80px时，定义的变量增加一个新的样式'header_bg'
    } 
    else if(window.location.href.indexOf("mmChain") >= 0){
      header && header.classList.add("header_bg");
    }
    else if(window.location.href.indexOf("home") >= 0){
      header && header.classList.add("header_bg");
    }
    else {
      header && header.classList.remove("header_bg"); //否则就移除'header_bg'样式
    }
  };

  renderModal = (flag) => {
    this.setState({
      isShow: flag,
    });
  };

  render() {
    const active = this.state.active;
    return (
      <div className='header' id="header">
        <div className="top">
          <div className="center clearfix">
            <div className="header-left fl">
              <div className="logo fl" id="xmtd-logo">
                <h1 className="site-name">小麦助教</h1>
                <a href="index.html">
                  <div className="img"></div>
                </a>
              </div>
            </div>
            <div className="header-right fr">
              <div className="nav fl">
                <ul className="nav-bar-title">
                  <li
                    className={
                      active === "home" ? "nav-bar-li on" : "nav-bar-li"
                    }
                  >
                    <Link href="/home">首页</Link>
                  </li>
                  <li
                    className={
                      active === "product" ? "nav-bar-li on" : "nav-bar-li"
                    }
                    id="show-choice"
                  >
                    <a>产品</a>
                    <span className="icon iconfont">&#xe614;</span>
                    <div id="module-choice" className="module-choice bgc-white">
                      <div className="triangle-up"></div>
                      <div
                        className="module-father"
                        style={{ position: "position", top: "-9px" }}
                      >
                        <ul
                          className="module-choice-hover bgc-white"
                          style={{ top: "8px", left: -150 }}
                        >
                          <li>
                            <div
                              className="fl"
                              style={{ width: "180px"}}
                            >
                              {/* <Link href="/xmErp">
                                <div className="fl icon xmzj"></div>
                                <div className="fl text">
                                  <p className="title">小麦助教</p>
                                  <p className="detail">校务管理</p>
                                </div>
                              </Link>
                              <Link href="/cloudClass" style={{margin:'10px 0'}}>
                                <div className="fl icon ykt"></div>
                                <div className="fl text">
                                  <p className="title">云课堂</p>
                                  <p className="detail">在线教学</p>
                                </div>
                              </Link>
                              <Link href="/xmSchoolInfo">
                                <div className="fl icon xmxxt"></div>
                                <div className="fl text">
                                  <p className="title">小麦校讯通</p>
                                  <p className="detail">家校服务</p>
                                </div>
                              </Link>
                              <Link href="/microBrandWeb" style={{margin:'10px 0'}}>
                                <div className="fl icon wgw"></div>
                                <div className="fl text">
                                  <p className="title">微官网</p>
                                  <p className="detail">品牌传播</p>
                                </div>
                              </Link>
                            </div>
                            <div className="fr">
                              <Link href="/xmShow">
                                <div className="fl icon xmx"></div>
                                <div className="fl text">
                                  <p className="title">小麦秀</p>
                                  <p className="detail">招生营销</p>
                                </div>
                              </Link>
                              <Link href="/mmCheckIn" style={{margin:'10px 0'}}>
                                <div className="fl icon mmdk"></div>
                                <div className="fl text">
                                  <p className="title">麦麦打卡</p>
                                  <p className="detail">课后督学</p>
                                </div>
                              </Link>
                              <Link href="/mmPoster">
                                <div className="fl icon poster"></div>
                                <div className="fl text">
                                  <p className="title">麦萌海报</p>
                                  <p className="detail">品牌设计</p>
                                </div>
                              </Link>
                              <Link href="/mmChain" style={{margin:'10px 0'}}>
                                <div className="fl icon icon-chain"></div>
                                <div className="fl text">
                                  <p className="title">小麦连锁版</p>
                                  <p className="detail">多校区管理</p>
                                </div>
                              </Link> */}
                            </div>
                          </li>
                        </ul>
                      </div>
                    </div>
                  </li>
                  <li
                    className={
                      active === "customerCase" ? "nav-bar-li on" : "nav-bar-li"
                    }
                  >
                    <Link href="/customercase">客户案例</Link>
                  </li>
                  <li
                    className={
                      active === "joinIn" ? "nav-bar-li on" : "nav-bar-li"
                    }
                    id="show-us"
                  >
                    <a>招商加盟</a>
                    <span className="icon iconfont">&#xe614;</span>
                    <div id="about-choice" className="module-choice bgc-white">
                      <div className="triangle-up"></div>
                      <div
                        className="module-father"
                        style={{
                          position: "relative",
                          top: "-9px",
                          width: 126,
                        }}
                      >
                        <ul
                          className="module-choice-hover bgc-white"
                          style={{ top: 18, width: 138, left: 10 }}
                        >
                          <li id="xmtd-sumary">
                            <Link href="/wheatsystem">小麦助教系统</Link>
                          </li>
                        </ul>
                      </div>
                    </div>
                  </li>
                  <li
                    className={
                      active === "wheatSchool" ? "nav-bar-li on" : "nav-bar-li"
                    }
                  >
                    <Link href="/wheatschool">小麦学院</Link>
                  </li>
                  <li
                    className={
                      active === "aboutUs" ? "nav-bar-li on" : "nav-bar-li"
                    }
                    id="show-us"
                  >
                    <a>关于我们</a>
                    <span className="icon iconfont">&#xe614;</span>
                    <div id="about-choice" className="module-choice bgc-white">
                      <div className="triangle-up"></div>
                      <div
                        className="module-father"
                        style={{
                          position: "relative",
                          top: "-9px",
                          width: 126,
                        }}
                      >
                        <ul
                          className="module-choice-hover bgc-white"
                          style={{ top: 18 }}
                        >
                          <li id="xmtd-sumary">
                            <Link href="/companyprofile">公司简介</Link>
                          </li>
                          <li id="xmtd-team-pic">
                            <Link href="/honoraryCertificate">荣誉资质</Link>
                          </li>
                          <li id="xmtd-join-us">
                            <Link href="/joinUs">加入我们</Link>
                          </li>
                          <li id="xmtd-news">
                            <Link href="/newsDynamic">新闻动态</Link>
                          </li>
                        </ul>
                      </div>
                    </div>
                  </li>
                </ul>
              </div>
              <div className="login-box fl">
                <span
                  className="free-trial btn fl"
                  id="free-try"
                  onClick={() => {
                    this.renderModal(true);
                  }}
                >
                  免费试用
                </span>
                <a
                  href="https://b.xiaomai5.com"
                  target="_blank"
                  rel="noopener noreferrer"
                >
                  <span className="login btn" id="xmtd-inst-login">
                    机构登录
                  </span>
                </a>
              </div>
            </div>
          </div>
        </div>

        {/* {this.state.isShow ? (
          <FreeTrial handModalShow={this.renderModal}></FreeTrial>
        ) : (
          ""
        )} */}
      </div>
    );
  }
}

export default Header;
