/*
 * @Author: zhujiapeng
 * @Date: 2021-06-04 14:38:09
 * @LastEditors: liguokang
 * @LastEditTime: 2021-07-14 20:39:36
 * @Description: 公司简介页面
 * @Copyright: ©2021 杭州杰竞科技有限公司 版权所有
 */

import Header from '../components/Header';
import Footer from '../components/Footer';
import SiderBar from '../components/SiderBar';
import './CompanyProfile.less';

export default function CompanyProfile() {
  return (
    <div className="company-profile" style={{ background: "#fff" }}>
      <Header active={"aboutUs"}></Header>
      <div className="swiper-img">
        <div className="swiper-img-content center">
          <p>为教育产业赋能</p>
          <span>
            小麦助教，隶属于杭州杰竞科技有限公司，是专业的教育信息化全场景服务商，以数据和技术为引擎，为教育机构提供一站式数字化运营管理解决方案，致力于构建教育信息化新生态。目前已成功服务超80000家教育品牌， 超105万位教育从业者，连接近4500万名学员和家长。
          </span>
        </div>
      </div>
      <div className="content">
        <div className="center">
          <div
            className="content-module content-module-1"
            style={{ paddingTop: 0, background: '#fff' }}
          >
            <div className="content-module-body">
              <p>
                基于互联网领域的创新技术及对用户行为的洞察，小麦助教打通了教育机构线上线下的各类真实场景，实现教育机构的信息化办公，极大提升了教育行业的整体经营效率。目前小麦助教的业务已覆盖全国200多个城市和地区，现产品体系包含小麦助教管理系统、小麦秀、小麦校讯通、小麦云课堂、麦麦打卡、小麦学院、小麦收银等，帮助教育机构解决招生营销、教务管理、家校服务、在线教学、课后督学、品牌传播、经营进阶等全流程运营管理难题，率先实现了在SaaS信息化服务、内容营销、金融服务等多元领域的落地应用。
              </p>
              <p>以“为教育产业赋能”为使命，小麦助教愿做教育路上的助力者，用科技创新为中国的教育事业贡献力量。</p>
            </div>
          </div>
        </div>
        <div className="content-module content-module-1">
          <div className="center">
            <div className="module-title">我们的价值观</div>
            <div className="content-module-img">
              <div className="img">
                <img
                  src="https://image.xiaomaiketang.com/xm/x8ErbPGQXD.png"
                  alt="小麦助教价值观-严谨"
                  title="小麦助教价值观-严谨"
                />
                <div className="img-tip">
                  <h2>严谨</h2>
                  <span>RIGOROUS</span>
                </div>
              </div>
              <div className="img">
                <img
                  src="https://image.xiaomaiketang.com/xm/GxeN3dHHz5.png"
                  alt="小麦助教价值观-激情"
                  title="小麦助教价值观-激情"
                />
                <div className="img-tip">
                  <h2>激情</h2>
                  <span>ENTHUSIASM</span>
                </div>
              </div>
              <div className="img">
                <img
                  src="https://image.xiaomaiketang.com/xm/ZyxZh3SHTa.png"
                  alt="小麦助教价值观-成长"
                  title="小麦助教价值观-成长"
                />
                <div className="img-tip">
                  <h2>成长</h2>
                  <span>DEVELOPMENT</span>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div className="content-module content-module-1" style={{ background: '#fff' }}>
          <div className="center">
            <div className="module-title">我们的服务宗旨</div>
            <div className="content-module-img">
              <div className="img1">
                <img
                  style={{ width: "100%" }}
                  src="https://image.xiaomaiketang.com/xm/y4zh3eWWXM.png"
                  alt="小麦助教服务宗旨-客户成功，小麦成功"
                  title="小麦助教服务宗旨-客户成功，小麦成功"
                />
                <div className="img-tip">客户成功 小麦成功</div>
              </div>
            </div>
          </div>
        </div>
        <div className="content-module content-module-2">
          <div className="center">
            <div id="team-pic" className="anchor"></div>
            <div className="module-title">团队照片</div>
            <div className="content-module-body">
              <div className="picture-wrap center">
                <div className="left">
                  <div className="top tran-scale">
                    <img
                      src="https://image.xiaomaiketang.com/xm/GixsZkGpYA.png"
                      alt="小麦助教团队照片"
                    />
                  </div>
                  <div className="bottom tran-scale">
                    <img
                      src="https://image.xiaomaiketang.com/xm/rmxbJd8fdD.png"
                      alt="小麦助教团队照片"
                    />
                  </div>
                </div>

                <div className="right">
                  <div className="top">
                    <div className="top-left tran-scale">
                      <img
                        src="https://image.xiaomaiketang.com/xm/Sryk6k7mwB.png"
                        alt="小麦助教团队照片"
                      />
                    </div>
                    <div className="top-right tran-scale">
                      <img
                        src="https://image.xiaomaiketang.com/xm/axyPA5EpkY.png"
                        alt="小麦助教团队照片"
                      />
                    </div>
                  </div>
                  <div className="middle tran-scale">
                    <img
                      src="https://image.xiaomaiketang.com/xm/5rHjiWnPGh.png"
                      alt="小麦助教团队照片"
                    />
                  </div>
                  <div className="bottom">
                    <div className="bottom-left tran-scale">
                      <img
                        src="https://image.xiaomaiketang.com/xm/hxWNwYB7F6.png"
                        alt="小麦助教团队照片"
                      />
                    </div>
                    <div className="bottom-right tran-scale">
                      <img
                        src="https://image.xiaomaiketang.com/xm/dkbNb3x2E2.png"
                        alt="小麦助教团队照片"
                      />
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <Footer></Footer>
      <SiderBar />
    </div>
  );
}
