/*
 * @Author: zhujiapeng
 * @Date: 2021-06-03 17:34:09
 * @LastEditors: zhujiapeng
 * @LastEditTime: 2021-06-04 14:08:53
 * @Description: 荣誉资质界面
 * @Copyright: ©2021 杭州杰竞科技有限公司 版权所有
 */

import { honoraryContant } from '../contants/honorary-certificate';
import Header from '../components/Header';
import Footer from '../components/Footer';
import SiderBar from '../components/SiderBar';
import './HonoraryCertificate.less';

export default function HonoraryCertificate() {
  return (
    <div className='honorary-certificate'>
      <Header />
      <div className="honorary-certificate-title">
        <div className="center" style={{ textAlign: "center" }}>
          <p>荣誉资质</p>
        </div>
      </div>
      <div className='content'>
        <div className='center'>
          <div className='honorary-area'>
            {
              honoraryContant.map((item) => {
                return (
                  <div className='honorary-list'>
                    <img src={item.imgUrl} alt={item.desc} title={item.desc} />
                    <p>{item.desc}</p>
                  </div>
                );
              })
            }
          </div>
        </div>
      </div>
      <div className='footer'>
        <Footer isTrial={false} />
        <SiderBar />
      </div>
    </div>
  )
}
