/*
 * @Author: zhujiapeng
 * @Date: 2021-06-02 15:08:14
 * @LastEditors: liguokang
 * @LastEditTime: 2021-07-14 20:39:57
 * @Description: 主页
 * @Copyright: ©2021 杭州杰竞科技有限公司 版权所有
 */

import { Button } from 'antd';
import Link from 'next/link';
import Header from '../components/Header';
import Footer from '../components/Footer';
import SiderBar from '../components/SiderBar';
import CarouselArea from '../components/CarouselArea';
import '../styles/globals.less';
import './index.less';
import {
  ProductContant,
  coreAdvantageContant,
  customerNumContant
} from '../contants/home';

export default function Home() {
  return (
    <div className='home'>
      <Header />
      {/* <CarouselArea /> */}
      <div className='content'>
        <div className='operate-solutions'>
          <div className='center'>
            <div className='big-title'>为教培机构提供全场景运营管理解决方案</div>
            <div className='product-area'>
              {
                ProductContant.map((item) => {
                  return (
                    <div
                      className="product"
                      onClick={() => {
                        this.handleToPage("/cloudClass");
                      }}
                    >
                      <div className="icon ykt">
                        <img src={item.imgUrl} alt={item.desc} title={item.desc} />
                      </div>
                      <div className="module-content">
                        <div className="title">{item.name}</div>
                        <div className="content">
                          {item.desc}
                        </div>
                        <div className="line"></div>
                        <Button>{item.buttonName}</Button>
                        <div className="go">
                          <img
                            src="https://image.xiaomaiketang.com/xm/BmKYSyet2Q.png"
                            alt="右箭头icon"
                          />
                        </div>
                      </div>
                    </div>
                  )
                })
              }
            </div>
          </div>
        </div>
        <div className='core-advantage'>
          <div className='center'>
            <div className='big-title'>四大核心优势，为校区发展保驾护航</div>
            <div className='department'>
              {
                coreAdvantageContant.map((item) => {
                  return (
                    <div className='department-tem'>
                      <img src={item.imgUrl} alt={item.desc} title={item.desc} />
                      <em />
                      <span className='title'>{item.name}</span>
                      <span className='desc'>{item.desc}</span>
                    </div>
                  )
                })
              }
            </div>
          </div>
        </div>
        <div className='customer-present'>
          <div className='center'>
            <div className='big-title'>用心做产品，赢得客户信赖</div>
            <div className='numBox'>
              {
                customerNumContant.map((item) => {
                  return (
                    <div>
                      <span className='count'>{item.count}万</span>
                      <span className='company'>{item.company}</span>
                      <p className='desc'>{item.desc}</p>
                    </div>
                  );
                })
              }
            </div>
            <div className='cooperative-enterprise'>
              <img src='https://image.xiaomaiketang.com/xm/EWApYHJSKz.png' alt='小麦助教合作企业' />
              <Link href="/about">
                <a className='more-case'>查看更多案例</a>
              </Link>
            </div>
          </div>
        </div>
      </div>
      <div className='footer'>
        <Footer isTrial={true} />
        <SiderBar />
      </div>
    </div>
  );
}
