/*
 * @Author: liguokang
 * @Date: 2021-07-14 20:38:28
 * @LastEditors: liguokang
 * @LastEditTime: 2021-07-29 17:58:58
 * @Description:
 * @Copyrigh: ©2021 杭州杰竞科技有限公司 版权所有
 */

// http://eslint.org/docs/user-guide/configuring

module.exports = {
  root: true,
  parser: 'babel-eslint',
  parserOptions: {
    sourceType: 'module',
  },
  env: {
    browser: true,
    es6: false,
  },
  extends: 'airbnb-base',
  plugins: ['html'],
  rules: {
    indent: [0, 2],
    complexity: [0, { max: 12 }],
    radix: 0,
    eqeqeq: 0,
    quotes: [
      1,
      'single',
      {
        allowTemplateLiterals: true,
      },
    ],
    'arrow-parens': 0,
    'global-require': 0,
    'max-nested-callbacks': [0, 3],
    'max-depth': [2, 5],
    'max-len': [2, 160],
    'react/react-in-jsx-scope': 0,
    'class-methods-use-this': 0,
    'object-shorthand': 0,
    'func-names': 0,
    'spaced-comment': 0,
    'prefer-template': 0,
    'prefer-arrow-callback': 0,
    'arrow-body-style': 0,
    'guard-for-in': 0,
    'space-before-function-paren': 0,
    'linebreak-style': [0, 2, 'windows'],
    'comma-dangle': [
      1,
      {
        arrays: 'always-multiline',
        objects: 'always-multiline',
        imports: 'always-multiline',
        exports: 'always-multiline',
        functions: 'always-multiline',
      },
    ],
    'prefer-destructuring': [
      0,
      {
        array: true,
        object: true,
      },
    ],
    'prefer-const': 1,
    'dot-notation': 0,
    'prefer-const': 0,
    'object-curly-newline': 0,
    camelcase: 0,
    '@typescript-eslint/prefer-interface': 0,
    '@typescript-eslint/camelcase': 0,
    '@typescript-eslint/explicit-function-return-type': 0,
    '@typescript-eslint/no-explicit-any': 0,
    '@typescript-eslint/no-unused-vars': 0,
    '@typescript-eslint/indent': [0, 2],
    'operator-linebreak': 0,
    'import/prefer-default-export': 0,
    'import/no-named-as-default-member': 0,
    'import/no-named-as-default': 0,
    'import/first': 0,
    'import/extensions': [
      2,
      'always',
      {
        js: 'never',
        ts: 'never',
        tsx: 'never',
        jsx: 'never',
        vue: 'never',
      },
    ],
    'import/no-extraneous-dependencies': [
      2,
      {
        optionalDependencies: ['test/unit/index.js'],
      },
    ],
    'no-param-reassign': 0,
    'no-plusplus': 0,
    'no-nested-ternary': 1,
    'no-alert': process.env.NODE_ENV === 'production' ? 2 : 0,
    'no-console': process.env.NODE_ENV === 'production' ? 2 : 0,
    'no-debugger': process.env.NODE_ENV === 'production' ? 2 : 0,
    'no-shadow': 0,
    'no-underscore-dangle': 0,
    'no-restricted-syntax': [2, 'LabeledStatement', 'WithStatement'],
    'no-unused-vars': 0,
    'no-use-before-define': 0,
    'no-lonely-if': 0,
    'no-unused-expressions': 0,
    'no-dupe-keys': 2,
    'no-duplicate-case': 2,
    'no-dupe-args': 2,
    'no-dupe-class-members': 2,
    'no-unused-vars': 0,
    'no-var': 2,
    'no-empty': 0,
    'no-else-return': 0,
    'no-new': 0,
    'no-continue': 0,
    'no-void': 0,
    'no-nested-ternary': 0,
    'no-mixed-operators': 0,
    'no-unneeded-ternary': 0,
    'no-restricted-globals': [
      0,
      {
        name: 'location',
        message: 'Use local parameter instead.',
      },
    ],
    'default-case': 0,
    'consistent-return': 0,
    'operator-assignment': 0,
    'function-paren-newline': 0,
    'array-callback-return': 0,
  },
};
