/*
 * @Author: liguokang
 * @Date: 2021-07-15 10:28:10
 * @LastEditors: liguokang
 * @LastEditTime: 2021-07-28 11:14:33
 * @Description:
 * @Copyrigh: ©2021 杭州杰竞科技有限公司 版权所有
 */
import React from 'react';
import Head from 'next/head';
import { changeCity } from '../../redux/action';
// 组件
import XMHeader from './XMHeader/laHeader';
import XMFooter from './XMFooter/LaFooter';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
const Fragment = React.Fragment;

class Layout extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      phone: '',
    };
  }
  static propTypes = {
    title: PropTypes.string,
    isHome: PropTypes.bool,
    useAntd: PropTypes.bool,
    noTop: PropTypes.bool,
    noFooter: PropTypes.bool,
  };

  componentDidMount() {
    if (window.location.pathname !== '/') {
    }
  }
  render() {
    let mLink = '';
    const { title } = this.props;
    let city = '';
    if (this.state.cityname) {
      city = this.state.cityname;
      mLink = this.state.hostname[1];
    }

    return (
      <div style={{ minHeight: '100vh', position: 'relative' }}>
        <Head>
          <title>{title || `${city} `}</title>
          <meta charSet="utf-8" />
          <meta name="viewport" content="initial-scale=1.0, width=device-width" />
          <meta name="viewport" content="width=device-width, initial-scale=1.0" />
          <meta httpEquiv="X-UA-Compatible" content="IE=edge,chrome=1" />
          <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
          <meta http-equiv="Pragma" content="no-cache" />
          <meta http-equiv="Expires" content="0" />
          <meta name="renderer" content="webkit|ie-comp|ie-stand" />
          <meta name="keywords" content=" " />
          <meta name="description" content="" />
          <meta name="format-detection" content="telephone=no,email=no" />
          <meta httpEquiv="mobile-agent" content={'format=xhtml;url=' + mLink} />
          <link type="image/x-icon" rel="shortcut icon" href="static/images/favicon.ico" />
          <link rel="stylesheet" href="/static/styles/globals.css" />
          <script async defer src=" " />
        </Head>

        <XMHeader city={this.state.cityname} changeCity={this.props.changeCity} noTop={this.props.noTop} />
        {this.props.children}
        {this.props.noFooter || (
          <Fragment>
            <XMFooter phone={this.state.phone} />
          </Fragment>
        )}
      </div>
    );
  }
}
export default Layout;
