/*
 * @Author: liguokang
 * @Date: 2021-07-14 20:36:28
 * @LastEditors: liguokang
 * @LastEditTime: 2021-07-29 16:45:28
 * @Description:
 * @Copyrigh: ©2021 杭州杰竞科技有限公司 版权所有
 */

const withLessExcludeAntd = require('./next-less.config.js');
const path = require('path');
const webpack = require('webpack');

if (typeof require !== 'undefined') {
  require.extensions['.less'] = (file) => {};
}

module.exports = withLessExcludeAntd({
  cssModules: true,
  cssLoaderOptions: {
    localIdentName: '[local]___[hash:base64:5]',
  },
  lessLoaderOptions: {
    javascriptEnabled: true,
  },
  exportPathMap: async function (defaultPathMap) {
    return Object.assign({
      '/': { page: '/' },
      '/404.html': { page: '/404' },
      '/wheatSchool.html': { page: '/wheatSchool' },
    });
  },
  webpack(config, options) {
    config.resolve.alias['@'] = path.join(__dirname, 'common');
    config.resolve.alias['components'] = path.join(__dirname, 'components');
    config.resolve.alias['static'] = path.join(__dirname, 'static');

    config.plugins.push(
      new webpack.DefinePlugin({
        'process.env': {
          DEPLOY_ENV: JSON.stringify(process.env.DEPLOY_ENV),
        },
      }),
    );
    if (config.externals) {
      const includes = [/antd/];
      config.externals = config.externals.map((external) => {
        if (typeof external !== 'function') return external;
        return (ctx, req, cb) =>
          includes.find((include) => (req.startsWith('.') ? include.test(path.resolve(ctx, req)) : include.test(req))) ? cb() : external(ctx, req, cb);
      });
    }
    return config;
  },
});
