/*
 * @Author: liguokang
 * @Date: 2021-07-29 16:14:30
 * @LastEditors: liguokang
 * @LastEditTime: 2021-07-29 16:37:00
 * @Description:
 * @Copyrigh: ©2021 杭州杰竞科技有限公司 版权所有
 */

const fs = require('fs');
const webConfigs = require('./common/webConfigs');

const readStream = fs.createReadStream('./sitemap/sitemap.html', { encoding: 'utf8' });
const writeStream = fs.createWriteStream('./dist/sitemap.html', { encoding: 'utf8' });

console.log(webConfigs, '11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111');
console.log(process.env.DEPLOY_ENV);

let env = {
  dev: 'https://dev.xiaomai5.com/',
  rc: 'https://rc.xiaomai5.com/',
  gray: 'https://rc.xiaomai5.com/',
  prod: 'https://www.xiaomai5.com/',
};
let inter = {
  dev: 'https://dev-heimdall.xiaomai5.com/',
  rc: 'https://rc-heimdall.xiaomai5.com/',
  gray: 'https://gray-heimdall.xiaomai5.com/',
  prod: 'https://heimdall.xiaomai5.com/',
};
readStream.on('data', (data) => {
  let reData = data.replace(/https\:\/\/www\.xiaomai5\.com\//g, env[process.env.DEPLOY_ENV || 'prod']);
  reData = reData.replace(/https\:\/\/heimdall\.xiaomai5\.com\//g, inter[process.env.DEPLOY_ENV || 'prod']);
  writeStream.write(reData, () => {
    console.log('sitemap.html copy success!');
  });
});
const readStream2 = fs.createReadStream('./sitemap/sitemap.xml', { encoding: 'utf8' });
const writeStream2 = fs.createWriteStream('./dist/sitemap.xml', { encoding: 'utf8' });
readStream2.on('data', (data) => {
  writeStream2.write(data, () => {
    console.log('sitemap.xml copy success!');
  });
});
const readStream3 = fs.createReadStream('./sitemap/robots.txt', { encoding: 'utf8' });
const writeStream3 = fs.createWriteStream('./dist/robots.txt', { encoding: 'utf8' });
readStream3.on('data', (data) => {
  writeStream3.write(data, () => {
    console.log('robots copy success!');
  });
});
