/*
 * @Author: zhujiapeng
 * @Date: 2021-06-04 15:09:14
 * @LastEditors: liguokang
 * @LastEditTime: 2021-07-14 20:40:16
 * @Description: 新闻动态页面
 * @Copyright: ©2021 杭州杰竞科技有限公司 版权所有
 */

import { useState, useEffect } from 'react';
import Header from '../components/Header';
import Footer from '../components/Footer';
import SiderBar from '../components/SiderBar';
import moment from 'moment';
import { Pagination } from 'antd';
// import NewsAPI from "../data-source/news/news-apis";
import axios from 'axios';
import './newsDynamic.less';

export default function NewsDynamic() {
  const [list, setList] = useState([]); // 新闻列表
  const [total, setTotal] = useState(0);
  const [query, setQuery] = useState({
    current: 1,
    size: 10
  });

  useEffect(() => {
    getList();
  }, []);

  // 获取新闻列表
  function getList() {
    const params = {
      ...query,
    };

    axios.post('https://heimdall.xiaomai5.com/workbench/anon/website/fetchPublishedNews', params).then((res) => {
      const { data: { result } } = res;
      const { records, total } = result;
      setList(records);
      setTotal(total);
    });
  }

  return (
    <div className="" style={{ background: "#fff" }}>
      <Header active={'aboutUs'}></Header>
      <div className="news-dynamic">
        <div className="center">
          <p>新闻动态</p>
        </div>
      </div>
      <div id="news" className="center">
        {list &&
          list.map((item, index) => {
            return (
              <div className="news-list" key={index} onClick={() => {
                this.props.history.push({
                  pathname: '/newsDetail',
                  state: {
                    item
                  }
                })
              }}>
                <div className="img">
                  <img src={item.coverUrl} alt="" />
                </div>
                <div className="content">
                  <h1>{item.title}</h1>
                  <div className="item-content"> {item.summary}</div>
                  <span className="item-source">来源： {item.source} </span>
                  <span className="item-time"> {moment(Number(item.publishTime)).format("YYYY-MM-DD HH:mm")} </span>
                </div>
              </div>
            );
          })}
          <Pagination
            // style={{ textAlign: 'right' }}
            current={query.current}
            pageSize={query.size}
            // onChange={this.getEffectActivity}
            total={total} />
      </div>
      <Footer></Footer>
      <SiderBar />
    </div>
  )
}
