/*
 * @Author: liguokang
 * @Date: 2021-06-03 13:46:20
 * @LastEditors: liguokang
 * @LastEditTime: 2021-06-16 15:24:26
 * @Description:
 * @Copyrigh: ©2021 杭州杰竞科技有限公司 版权所有
 */
import { getToken } from '@/utils/auth';
import User from '@/core/user';

export function getHeaders(product, module, httpMethod, tempToken, xmKey) {
  const headers = {
    module: module,
    product: product,
    Accept: 'application/json',
    appId: User.appId() || '',
    openId: User.openId() || '',
    userId: User.uid() || '',
    p: 'wechat',
    v: 'v5.0.0',
    userType: 'C',
    tempToken: tempToken || '',
    xmKey: xmKey || '',
  };
  headers['Content-Type'] = 'application/json;charset=UTF-8';
  headers['httpMethod'] = typeof httpMethod === 'string' ? httpMethod.toLowerCase() : httpMethod; // for example "post",
  headers['xmToken'] = getToken() || tempToken || ''; // 让每个请求携带自定义token 请根据实际情况自行修改
  return headers;
}
