/*
 * @Author: zhujiapeng
 * @Date: 2021-06-04 15:28:23
 * @LastEditors: zhujiapeng
 * @LastEditTime: 2021-06-04 16:06:40
 * @Description: 加入我们页面
 * @Copyright: ©2021 杭州杰竞科技有限公司 版权所有
 */

import { useState, useLayoutEffect } from 'react';
import { getJobs } from "../data-source/join-us/request-apis";
import Header from '../components/Header';
import Footer from '../components/Footer';
import SiderBar from '../components/SiderBar';
import "./joinUs.less";

export default function JoinUs() {
  const [jobs, setJobs] = useState([]);
  const [selectJobs, setSelectJobs] = useState([]);
  const [postTypeFlag, setPostTypeFlag] = useState(0); // 职位类别标记
  const [jobNatureFlag, setJobNatureFlag] = useState(0); // 工作性质标记
  const [detailFlag, setDetailFlag] = useState(-1);

  useLayoutEffect(() => {
    getData();
  }, []);

  // 获取数据
  async function getData() {
    const { data } = await getJobs();
    setJobs(data);
    setSelectJobs(data);
  }

  function handSelectNature(type, flag) {
    const selectJobs =
      type === "全部"
        ? jobs
        : jobs.filter((item) => item.jobNature.indexOf(type) !== -1);
    setSelectJobs(selectJobs);
    setJobNatureFlag(flag);
  }

  function handSelectType(type, flag) {
    const selectJobs =
      type === "全部"
        ? jobs
        : jobs.filter((item) => item.postType == type);
    setSelectJobs(selectJobs);
    setPostTypeFlag(flag);
  }

  return (
    <div className="" style={{ background: "#fff" }}>
      <Header active={"aboutUs"} />
      <div className="join-us">
        <div className="center" style={{ textAlign: "center" }}>
          <p>加入我们，麦向美好未来</p>
        </div>
      </div>
      <div className="content">
        <div className="center">
          <div className="content-module" style={{ background: '#fff' }}>
            <div className="content-module-body">
              <p className="join-us-title">
                团队成员来自于浙江大学、清华大学、复旦大学、伦敦大学、新加坡国立大学等国内外知名高校，部分成员曾连续成功创业，在K12教育培训、移动互联网产品开发、大数据等领域深耕多年。其中研发和产品团队占据总人数1/2以上，硕士以上学历人数超过15%。
              </p>
            </div>
          </div>
        </div>

        <div
          className="content-module content-module-3"
          style={{ background: "#fff" }}
        >
          <div className="center">
            <div className="module-title">热招岗位</div>
            <div className="content-module-body">
              <div className="job-head">
                <div className="work-nature clearfix">
                  <span className="type-nature fl" id="xmtd-type-nature">
                    工作性质
                  </span>
                  <div className="button fl clearfix" id="nature">
                    <span
                      className={
                        jobNatureFlag === 0 ? "active" : ""
                      }
                      data-id="0"
                      onClick={() => {
                        handSelectNature("全部", 0);
                      }}
                    >
                      全部
                    </span>
                    <span
                      className={
                        jobNatureFlag === 1 ? "active" : ""
                      }
                      data-id="1"
                      onClick={() => {
                        handSelectNature("社招", 1);
                      }}
                    >
                      社招
                    </span>
                    <span
                      className={
                        jobNatureFlag === 2 ? "active" : ""
                      }
                      data-id="2"
                      onClick={() => {
                        this.handSelectNature("校招", 2);
                      }}
                    >
                      校招
                    </span>
                    <span
                      className={
                        jobNatureFlag === 3 ? "active" : ""
                      }
                      data-id="3"
                      onClick={() => {
                        handSelectNature("校招", 3);
                      }}
                    >
                      实习
                    </span>
                  </div>
                </div>
                <div className="job-category clearfix">
                  <span className="type fl">职位类别</span>
                  <div className="button fl clearfix" id="type">
                    <span
                      className={
                        postTypeFlag === 0 ? "active" : ""
                      }
                      data-index="0"
                      onClick={() => {
                        handSelectType("全部", 0);
                      }}
                    >
                      全部
                    </span>
                    <span
                      className={
                        postTypeFlag === 1 ? "active" : ""
                      }
                      data-index="1"
                      onClick={() => {
                        handSelectType("技术", 1);
                      }}
                    >
                      技术
                    </span>
                    <span
                      className={
                        postTypeFlag === 2 ? "active" : ""
                      }
                      data-index="2"
                      onClick={() => {
                        handSelectType("产品", 2);
                      }}
                    >
                      产品
                    </span>
                    <span
                      className={
                        postTypeFlag === 3 ? "active" : ""
                      }
                      data-index="3"
                      onClick={() => {
                        handSelectType("设计", 3);
                      }}
                    >
                      设计
                    </span>
                    <span
                      className={
                        postTypeFlag === 4 ? "active" : ""
                      }
                      data-index="4"
                      onClick={() => {
                        handSelectType("市场", 4);
                      }}
                    >
                      市场
                    </span>
                    <span
                      className={
                        postTypeFlag === 5 ? "active" : ""
                      }
                      data-index="5"
                      onClick={() => {
                        handSelectType("商务顾问", 5);
                      }}
                    >
                      销售
                    </span>
                    <span
                      className={
                        postTypeFlag === 6 ? "active" : ""
                      }
                      data-index="6"
                      onClick={() => {
                        handSelectType("运营", 6);
                      }}
                    >
                      运营
                    </span>
                  </div>
                </div>
              </div>
              <div className="job-detail" id="job-detail">
                <ul style={{ padding: 0 }}>
                  <li className="first" id="first">
                    <span>职位名称</span>
                    <span>工作性质</span>
                    <span>职位类别</span>
                    <span>工作经验</span>
                    <span>招聘人数</span>
                  </li>
                  {selectJobs.map((item, index) => {
                    return (
                      <div
                        key={index}
                        onClick={() => {
                          detailFlag === index ? setDetailFlag(-1) : setDetailFlag(index);
                        }}
                      >
                        <li className="title">
                          <span>{item.jobName}</span>
                          <span>{item.jobType}</span>
                          <span>{item.postType}</span>
                          <span>{item.jobExperience}</span>
                          <span className="num xmtd-num">
                            {item.NeedNum}
                            {detailFlag === index ? (
                              <i className="icon iconfont up active iconUp fr">
                                
                              </i>
                            ) : (
                              <i className="icon iconfont down active iconDown fr xmtd-num">
                                
                              </i>
                            )}
                          </span>
                        </li>
                        <li
                          className={
                            detailFlag === index
                              ? "detail active"
                              : "detail"
                          }
                          id="detail"
                        >
                          <div className="append">
                            <div className="duty">
                              <div className="title">岗位职责：</div>
                              <div className="list" id="duty-list">
                                {item.responsibility &&
                                  item.responsibility.map((item1, index1) => {
                                    return <p key={index1}>{item1}</p>;
                                  })}
                              </div>
                            </div>
                            <div className="require">
                              <div className="title">岗位要求：</div>
                              <div className="list" id="require-list">
                                {item.requirement &&
                                  item.requirement.map((item2, index2) => {
                                    return <p key={index2}>{item2}</p>;
                                  })}
                              </div>
                            </div>
                            <div className="mail">简历投递：liyan@xiaomai5.com</div>
                          </div>
                        </li>
                      </div>
                    );
                  })}
                </ul>
              </div>
            </div>
          </div>
        </div>
      </div>
      <Footer></Footer>
      <SiderBar />
    </div>
  );
}
