import Vue from 'vue';
import axios from 'axios';
import User from '../core/user';
// 创建axios实例
let serverPath = window.CONFIG.server;

if (SERVER) {
  serverPath = SERVER;
}

const service = axios.create({
  baseURL: serverPath, // api 的 base_url
  timeout: 20000, // 请求超时时间
});

// request拦截器
service.interceptors.request.use(
  config => {
    if (config.url.indexOf('public/') === -1 && User.token()) {
      return config;
    } else if (config.headers.module) {
      const url = JSON.parse(JSON.stringify(config.url));
      config.url = `${config.headers.module}/` + url;
      return config;
    } else {
      // config.baseURL = '';
      return config;
    }
  },
  error => {
    // Do something with request error
    Promise.reject(error);
  },
);

// response 拦截器
service.interceptors.response.use(
  response => {
    const { data } = response;
    const { code, result, message } = data;
    const rejectCode = [
      'LOGIN_OVERDUE',
      '10000',
      '10001',
      '10002',
      'RPC_FAIL',
      'ILLEGAL_ARGUMENT',
      'BASIC_INFO_ERROR',
      'SCHEDULE_HAS_REMOVE',
      'SCHEDULE_NONE_STUDENT',
      'NONE_PERMISSION_JOIN',
      'VERIFY_CODE_ERROR',
    ];
    if (code < 200 || code > 300) {
      if (code == 418) {
        window.location.href = 'https://www.xiaomai5.com/maintain.html';
      } else if (code == 401 || code == 403) {
        User.loginIn();
      } else {
        processHttpError(data);
      }
      return data;
      // return Promise.reject(new Error('error'));
    } else {
      if (rejectCode.indexOf(code) > -1) {
        console.table({
          time: new Date().toString(),
          code,
          errorInfo: message || result,
        });
        // return Promise.reject(data);
      }
      return data;
    }
  },
  error => {
    let code = 0;
    try {
      code = error.response.data.status;
      if (code == 418) {
        window.location.href = 'https://www.xiaomai5.com/maintain.html';
      } else if (code == 401 || code == 403) {
        User.loginIn();
      } else {
        processHttpError(error.response.data);
      }
    } catch (e) {
      if (error.toString().indexOf('Error: timeout') !== -1) {
        console.table({
          time: new Date().toString(),
          errorInfo: '网络请求超时',
        });
        return Promise.reject(error);
      }
      if (error.toString().indexOf('Error: Network Error') !== -1) {
        console.table({
          time: new Date().toString(),
          errorInfo: '网络请求错误',
        });
        return Promise.reject(error);
      }
    }

    return Promise.reject(error);
  },
);
function processHttpError(data) {
  let message = '';
  const status = Number(data.code) > 0 ? Number(data.code) : Number(data.status);
  const code = Number(data.code);
  if (status === 404) {
    message = '404 网络错误 \n 请检查你的本地网络是否连接';
  } else if (status === 500) {
    try {
      message = data.message || 'Oops! 500错误 \n 服务器异常';
    } catch (e) {
      message = 'Oops! 500错误 \n 服务器异常';
    }
  } else if (status === 0) {
    return;
  } else {
    message = data.message;
  }
  console.table({
    time: new Date().toString(),
    code: code > 0 ? code : status,
    errorInfo: message,
  });
  Vue.$wheatToast({
    message: message,
    position: 'middle',
  });
}
export default service;
