/*
 * @Description:
 * @Date: 2020-03-18 18:19:52
 * @LastEditTime: 2020-12-30 20:48:12
 * @LastEditors: JamosLi
 */
import React from 'react';
import style from './laFooter.less';
import Link from 'next/link';
import LazyLoad from 'react-lazyload';
import { StaticImg } from '@/api/interfaces';
import Button from 'baseTemplate/lib/button';
const Img = StaticImg + '/Footer';
import { open } from '@/lib/methods';

class LaFooter extends React.Component {
  render() {
    return (
      <footer className={style.laFooter}>
        <div className={style.laFooterList2}>
          <div className={style.List2Content}>
            <div className={style.FooterBox1}>
              <div>
                <h2>关于中禄</h2>
                <p>
                  <Link href={'/aboutUs'}>
                    <a>关于我们</a>
                  </Link>
                </p>
                <p>
                  <Link href={'/contactUs'}>
                    <a>联系我们</a>
                  </Link>
                </p>
              </div>
              <div>
                <h2>新手指南</h2>
                <p onClick={open}>
                  <a>在线咨询</a>
                </p>
                <p onClick={open}>
                  <a>财税资讯</a>
                </p>
                <p>
                  <Link href={'/login/cusRegister'}>
                    <a>新手注册</a>
                  </Link>
                </p>
              </div>
              <div>
                <h2>服务推荐</h2>
                <p>
                  <Link href={'/companyRegistration'}>
                    <a>公司注册</a>
                  </Link>
                </p>
                <p>
                  <Link href={'/agentAccount'}>
                    <a>代理记账</a>
                  </Link>
                </p>
                <p>
                  <Link href={'/qualification'}>
                    <a>资质办理</a>
                  </Link>
                </p>
                <p>
                  <Link href={'/BusinessService'}>
                    <a>商标知产</a>
                  </Link>
                </p>
              </div>
            </div>
            <div className={style.FooterBox2}>
              <div className={style.Box2Line}>
                <h3>服务热线</h3>
                <LazyLoad height={72}>
                  <p style={{ backgroundImage: `url('${Img}/dianhua.svg')` }}>{this.props.phone || 400 - 690 - 8028}</p>
                </LazyLoad>
                <Button mode={'red'} className={style.inlineChat}>
                  <a onClick={open}>在线咨询</a>
                </Button>
              </div>
            </div>
            <div className={style.FooterBox3}>
              <LazyLoad height={152}>
                <div className={style.weChat} style={{ backgroundImage: `url('${Img}/wechat-min.jpg')` }} />
                <span />
              </LazyLoad>
              <p>扫一扫，创业一手掌握</p>
            </div>
          </div>
        </div>
        <div className={style.laFooterList3}>
          <a target="_blank" href="https://beian.miit.gov.cn">
            <span>Copyright ©2017 浙江中禄财务咨询有限公司版权所有 浙ICP备16004996号-1</span>
          </a>
        </div>
      </footer>
    );
  }
}

export default LaFooter;
