// 框架依赖
import React from 'react';
import cookies from 'react-cookies';
import style from './laHeader.less';
import Link from 'next/link';
import { withRouter } from 'next/router';
import { logout } from '@/api/user';
import { setToPath, comingSoon } from '@/lib';
import { open } from '@/lib/methods';
import Icon from 'baseTemplate/lib/icon';
import { StaticImg } from '@/api/interfaces';
import store from '../../../redux/store';
import { connect } from 'react-redux';
import { getCity } from 'static/js/util';
const nav = [
  { val: '首页', link: '/' },
  { val: '工商注册', link: '/companyRegistration' },
  { val: '代理记账', link: '/agentAccount' },
  { val: '商标知产', link: '/BusinessService' },
  { val: '高新资质', link: '/qualification' },
  { val: '社保人事', link: '/socialSecurity' },
  { val: '项目申报', link: '/projectApplication' },
  { val: '财税资讯' },
];

class LaHeader extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      currentCity: '杭州',
      // 城市选择盒子状态
      cityBox: false,
      userName: '',
      anm: 0,
      citylist: [],
      phone: '',
    };
  }
  // 退出登录逻辑
  onLogout() {
    let path = window.location.href;
    logout(path);
    this.setState({
      userName: '',
    });
  }
  setAnm = (val) => {
    this.setState({
      anm: val,
    });
  };

  componentDidMount() {
    const cookieName = cookies.load('username');
    if (cookieName) {
      this.setState({ userName: cookieName });
    }
    getCity(this.props.cityMap, window.location.href).then((res) => {
      this.setState({ cityConfig: res });
      this.setState({ cityname: res.data.config.city });
    });
  }
  getMenuItems() {
    const cityList = this.state.cityConfig ? this.state.cityConfig.citylist : [];
    if (this.state.citylist) {
      return cityList.map((city) => {
        return (
          <div
            className={style.city}
            onClick={() => {
              //  切换城市
              if (city.hostname.length > 1) {
                window.location.href = '';
                if (window.location.search.length > 0) {
                  window.location.href = city.hostname[0] + window.location.pathname + window.location.search;
                } else {
                  window.location.href = city.hostname[0] + window.location.pathname;
                }
              } else {
                // this.props.changeCity(city.config.city);
                alert('此城市暂未开通服务，如需帮助请咨询客服！');
                this.setState({ cityname: city.config.city });
                this.setState({ cityBox: false });
              }
            }}
            key={city.config.city}
          >
            {city.config.city}
          </div>
        );
      });
    }
  }

  render() {
    let { config } = this.state.cityConfig ? this.state.cityConfig.data : { config: this.props.cityMap[0].config };
    return (
      <div>
        <header className={style.laHeader}>
          {/*顶部灰色栏*/}
          <div className={style.laTop} style={{ display: this.props.noTop ? 'none' : 'block' }}>
            <div className={style.topContent}>
              {/*地区选择器*/}
              <div
                className={style.CityList}
                onMouseEnter={() => {
                  this.setState({ cityBox: true });
                }}
                onMouseLeave={() => {
                  this.setState({ cityBox: false });
                }}
                style={{ backgroundColor: this.state.cityBox ? '#FFFFFF' : '' }}
              >
                <span className={style.currentCity} style={{ border: this.state.cityBox ? 'none' : '' }}>
                  {this.state.cityname ? this.state.cityname + '市' : ''}
                </span>
                <div className={style.cityBox} style={{ display: this.state.cityBox ? 'flex' : 'none' }}>
                  {this.getMenuItems()}
                </div>
              </div>
              <span className={style.number}>全国服务热线：{config.phone ? config.phone : '400-'}</span>

              {/*用户信息框*/}
              <div className={style.user}>
                {this.state.userName ? (
                  <div className={style.userDiv}>
                    {' '}
                    <Link href="/personalCenter/basicInfo">
                      <a>
                        <Icon name={'yongHu'} width={14} height={14} />
                        <span>欢迎你，{this.state.userName}</span>
                      </a>
                    </Link>
                    <div className={style.userBox}>
                      <ul>
                        <Link href={'/personalCenter/myOrder'}>
                          <a>
                            <li>
                              <svg xmlns="http://www.w3.org/2000/svg" width="11.403" height="13" viewBox="0 0 11.403 13">
                                <g id="dingdan-2" transform="translate(-1.58 -0.768)">
                                  <path
                                    id="路径_1608"
                                    data-name="路径 1608"
                                    d="M9.17,13.767l-7.589-.04L1.621.768l11.362.04V9.917a3.842,3.842,0,0,1-3.813,3.85Zm-6.782-.805H9.169a3.026,3.026,0,0,0,3.008-3.009l.04-8.378-9.83-.04V12.961Z"
                                    fill="#aebac4"
                                  />
                                  <path
                                    id="路径_1609"
                                    data-name="路径 1609"
                                    d="M9.677,4.151Zm0,0H4.233a.383.383,0,0,1-.4-.4.384.384,0,0,1,.4-.4H9.677a.384.384,0,0,1,.4.4.384.384,0,0,1-.4.4ZM9.5,7.054H4.306a.4.4,0,0,1,0-.807H9.5a.384.384,0,0,1,.4.4.4.4,0,0,1-.4.4ZM7.9,9.594H4.306a.4.4,0,1,1,0-.806H7.9a.384.384,0,0,1,.4.4.4.4,0,0,1-.4.4Z"
                                    fill="#aebac4"
                                  />
                                </g>
                              </svg>
                              <span>我的订单</span>
                            </li>
                          </a>
                        </Link>
                        <li onClick={this.onLogout.bind(this)}>
                          <svg xmlns="http://www.w3.org/2000/svg" width="10.859" height="13" viewBox="0 0 10.859 13">
                            <g id="tuichu" transform="translate(-1.529 -0.765)">
                              <path id="路径_1610" data-name="路径 1610" d="M1.529.765h.765V13H1.529Z" fill="#aebac4" />
                              <path id="路径_1611" data-name="路径 1611" d="M1.529.765h.765V13H1.529Zm8.412,0h.765V3.059H9.941Z" fill="#aebac4" />
                              <path id="路径_1612" data-name="路径 1612" d="M9.941.765h.765V3.059H9.941Zm0,10.706h.765v2.294H9.941Z" fill="#aebac4" />
                              <path
                                id="路径_1613"
                                data-name="路径 1613"
                                d="M9.941,11.471h.765v2.294H9.941ZM1.529.765H9.941v.765H1.529Z"
                                fill="#aebac4"
                              />
                              <path id="路径_1614" data-name="路径 1614" d="M1.529.765H9.941v.765H1.529ZM1.529,13H9.941v.765H1.529Z" fill="#aebac4" />
                              <path
                                id="路径_1615"
                                data-name="路径 1615"
                                d="M1.529,13H9.941v.765H1.529ZM3.824,6.882h7.647v.765H3.824Z"
                                fill="#aebac4"
                              />
                              <path id="路径_1616" data-name="路径 1616" d="M3.824,6.882h7.647v.765H3.824Z" fill="#aebac4" />
                              <path
                                id="路径_1617"
                                data-name="路径 1617"
                                d="M12.159,7.571l.229-.306L9.712,4.588l-.535.535,2.141,2.141L9.176,9.482l.535.535Z"
                                fill="#aebac4"
                              />
                            </g>
                          </svg>
                          <span>退出登录</span>
                        </li>
                      </ul>
                    </div>
                  </div>
                ) : (
                  <div
                    className={style.userDiv}
                    onClick={() => {
                      setToPath(this.props.router.asPath);
                    }}
                  >
                    <a href={`/login/cusLogin`}>
                      <span>登录</span>
                    </a>
                    <span>/</span>
                    <a href={`/login/cusRegister`}>
                      <span>免费注册</span>
                    </a>
                  </div>
                )}
              </div>
            </div>
          </div>

          {/*导航栏部分*/}
          <nav className={style.laNav}>
            <div className={style.laNavBody}>
              <div>
                <Link href="/">
                  <a style={{ marginRight: 20 }}>
                    <img src={StaticImg + '/logo.png'} width={121} alt="" />
                  </a>
                </Link>
                <div className={style.allService} style={{ cursor: 'pointer', minWidth: 102 }}>
                  <a onClick={open}>所有服务</a>
                </div>
              </div>
              <div>
                <ul>
                  {nav.map((item, index) => (
                    <li key={item.val} onClick={!!item.link ? null : comingSoon} style={{ cursor: 'pointer' }}>
                      {item.link ? (
                        <Link href={item.link}>
                          <a
                            target={item.val !== '首页' ? '_blank' : ''}
                            className={this.state.anm === index + 1 ? 'an' : ''}
                            onMouseLeave={this.setAnm.bind(this, 0)}
                            onMouseEnter={this.setAnm.bind(this, index + 1)}
                          >
                            {item.val}
                          </a>
                        </Link>
                      ) : (
                        <a
                          className={this.state.anm === index + 1 ? 'an' : ''}
                          onMouseLeave={this.setAnm.bind(this, 0)}
                          onMouseEnter={this.setAnm.bind(this, index + 1)}
                        >
                          {item.val}
                        </a>
                      )}
                    </li>
                  ))}
                  {/*<li ><Link href='/'><a className={this.state.anm===1?'an':''} onMouseLeave={this.setAnm.bind(this,0)} onMouseEnter={this.setAnm.bind(this,1)}>首页</a></Link></li>*/}
                  {/*<li ><Link href={'/companyRegistration'}><a className={this.state.anm===2?'an':''} onMouseLeave={this.setAnm.bind(this,0)} onMouseEnter={this.setAnm.bind(this,2)}>工商注册</a></Link></li>*/}
                  {/*<li ><Link href={'/agentAccount'}><a className={this.state.anm===3?'an':''} onMouseLeave={this.setAnm.bind(this,0)} onMouseEnter={this.setAnm.bind(this,3)}>代理记账</a ></Link></li>*/}
                  {/*<li ><Link href={'/about/BusinessService'}><a className={this.state.anm===4?'an':''} onMouseLeave={this.setAnm.bind(this,0)} onMouseEnter={this.setAnm.bind(this,4)}>商标知产</a></Link></li>*/}
                  {/*<li ><Link href='/qualification'><a className={this.state.anm===5?'an':''} onMouseLeave={this.setAnm.bind(this,0)} onMouseEnter={this.setAnm.bind(this,5)}>高新资质</a></Link></li>*/}
                  {/*<li onClick={comingSoon} style={{cursor:"pointer"}}><a className={this.state.anm===6?'an':''} onMouseLeave={this.setAnm.bind(this,0)} onMouseEnter={this.setAnm.bind(this,6)}>社保人事</a></li>*/}
                  {/*<li ><Link href={'/projectApplication'}><a className={this.state.anm===7?'an':''} onMouseLeave={this.setAnm.bind(this,0)} onMouseEnter={this.setAnm.bind(this,7)}>项目申报</a></Link></li>*/}
                  {/*<li onClick={comingSoon} style={{cursor:"pointer"}} ><a className={this.state.anm===8?'an':''} onMouseLeave={this.setAnm.bind(this,0)} onMouseEnter={this.setAnm.bind(this,8)}>财税资讯</a></li>*/}
                </ul>
              </div>
            </div>
          </nav>
          <style jsx>
            {`
              @keyframes myfirst {
                0% {
                  top: 0px;
                }
                50% {
                  top: -10px;
                }
                100% {
                  top: 0px;
                }
              }
              .an {
                animation: myfirst 0.4s;
              }
            `}
          </style>
        </header>
      </div>
    );
  }
}
// export default withRouter(LaHeader);
const mapStateToProps = ({ city, cityMap }) => ({ city, cityMap });
export default connect(mapStateToProps)(LaHeader);
