import React from 'react';
import Head from 'next/head';
import { changeCity } from '../../redux/action';
// 组件
import XMHeader from './XMHeader/laHeader';
import XMFooter from './XMFooter/LaFooter';
import PropTypes from 'prop-types';
import { noXiaoHan } from '@/lib/methods';
import Sidebar from '../base/sidebar';
import { connect } from 'react-redux';
import { getCity } from 'static/js/util';
const Fragment = React.Fragment;
 
class Layout extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      phone: '',
    };
  }
  static propTypes = {
    title: PropTypes.string,
    isHome: PropTypes.bool,
    useAntd: PropTypes.bool,
    noTop: PropTypes.bool,
    noFooter: PropTypes.bool,
  };

  componentDidMount() {
    if (window.location.pathname !== '/') {
      // 关闭个人中心和商标页的小韩
      noXiaoHan();
    }
    getCity(this.props.cityMap, window.location.href).then((res) => {
      let cityConfig = res.data;
      this.setState({ phone: cityConfig.config.phone });
      this.setState({ hostname: cityConfig.hostname });
      this.setState({ hmurl: cityConfig.config.hmurl });
      this.setState({ cityname: cityConfig.config.city });
      sessionStorage.setItem('pgtUrl', cityConfig.config.chatAnchor);
    });
  }
  render() {
    let mLink = '';
    let hmurl = '';
    const { title } = this.props;
    let city = '';
    if (this.state.cityname) {
      city = this.state.cityname;
      hmurl = this.state.hmurl;
      mLink = this.state.hostname[1];
    }

    return (
      <div style={{ minHeight: '100vh', position: 'relative' }}>
        <Head>
          <title>{title || `${city} `}</title>
          <meta charSet="utf-8" />
          <meta name="viewport" content="initial-scale=1.0, width=device-width" />
          <meta httpEquiv="X-UA-Compatible" content="IE=edge,chrome=1" />
          <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
          <meta http-equiv="Pragma" content="no-cache" />
          <meta http-equiv="Expires" content="0" />
          <meta name="renderer" content="webkit|ie-comp|ie-stand" />
          {/*添加keywords*/}
          {this.props.useImgHead && <meta name="referrer" content="no-referrer" />}
          <meta name="keywords" content=" " />
          <link type="image/x-icon" rel="shortcut icon" href="static/images/favicon.ico" />
          <link rel="stylesheet" href="/static/styles/ready.css" />
          {/* 部分老页面对antd.css这个文件有依赖,传递useAntd*/}
          <meta name="format-detection" content="telephone=no,email=no" />
          <meta httpEquiv="mobile-agent" content={'format=xhtml;url=' + mLink} />
          <meta name="description" content="" />
          <meta name="viewport" content="width=device-width, initial-scale=1.0" />
          <script async defer src=" " />

          <meta httpEquiv="Expires" content="0" />
        </Head>

        <XMHeader city={this.state.cityname} changeCity={this.props.changeCity} noTop={this.props.noTop} />
        {this.props.children}
        {this.props.noFooter || (
          <Fragment>
            <div style={{ width: '100%', height: 258, backgroundColor: '#fff' }}></div>
            <footer style={{ position: 'absolute', bottom: 0, width: '100%' }}>
              <XMFooter phone={this.state.phone} />
            </footer>
          </Fragment>
        )}

        <Sidebar props={{ phone: this.state.phone }} phone={this.state.phone} />
      </div>
    );
  }
}
export default connect(
  ({ city, cityMap }) => ({ city, cityMap }),
  (dispatchEvent) => {
    return {
      changeCity: (city) => {
        dispatchEvent(changeCity(city));
      },
    };
  },
)(Layout);
