/*
 * @Author: liguokang
 * @Date: 2021-07-14 20:38:28
 * @LastEditors: liguokang
 * @LastEditTime: 2021-07-29 17:56:46
 * @Description:
 * @Copyrigh: ©2021 杭州杰竞科技有限公司 版权所有
 */

// http://eslint.org/docs/user-guide/configuring

module.exports = {
  root: true,
  parser: 'babel-eslint',
  parserOptions: {
    sourceType: 'module',
  },
  env: {
    browser: true,
    es6: false,
  },
  extends: 'airbnb-base',
  plugins: ['html'],
  rules: {
    indent: [0, 2],
    complexity: [0, { max: 12 }],
    radix: 0,
    eqeqeq: 0,
    quotes: [
      1,
      'single',
      {
        allowTemplateLiterals: true,
      },
    ],
    'import/extensions': [
      0,
      'always',
      {
        js: 'never',
        vue: 'never',
      },
    ],
    'import/no-extraneous-dependencies': [
      0,
      {
        optionalDependencies: ['test/unit/index.js'],
      },
    ],
    'arrow-parens': 0,
    'global-require': 0,
    'no-param-reassign': 0,
    'no-plusplus': 0,
    'max-nested-callbacks': [0, 3],
    'max-depth': [0, 5],
    'max-len': [0, 160],
    'no-nested-ternary': 2,
    'no-alert': process.env.NODE_ENV === 'prod' ? 2 : 0,
    'no-console': process.env.NODE_ENV === 'prod' ? 2 : 0,
    'no-debugger': process.env.NODE_ENV === 'prod' ? 2 : 0,
    'default-case': 2,
    'no-shadow': 2,
    'no-underscore-dangle': 0,
    'react/react-in-jsx-scope': 0,
    'class-methods-use-this': 0,
    'no-restricted-syntax': [0, 'LabeledStatement', 'WithStatement'],
    'object-shorthand': 0,
    'func-names': 0,
    'no-unused-vars': 0,
    'spaced-comment': 0,
    'prefer-template': 0,
    'prefer-arrow-callback': 0,
    'no-use-before-define': 0,
    'arrow-body-style': 0,
    'no-lonely-if': 0,
    'no-unused-expressions': 0,
    'guard-for-in': 0,
    'no-dupe-keys': 2,
    'no-duplicate-case': 2,
    'no-dupe-args': 2,
    'no-dupe-class-members': 2,
    'no-unused-vars': 0,
    'no-var': 2,
    'no-empty': 0,
    'space-before-function-paren': 0,
    'no-else-return': 0,
    'no-new': 0,
    'linebreak-style': [0, 0, 'windows'],
    'comma-dangle': [
      1,
      {
        arrays: 'always-multiline',
        objects: 'always-multiline',
        imports: 'always-multiline',
        exports: 'always-multiline',
        functions: 'always-multiline',
      },
    ],
    'no-restricted-globals': [
      0,
      {
        name: 'location',
        message: 'Use local parameter instead.',
      },
    ],
    'prefer-destructuring': [
      0,
      {
        array: true,
        object: true,
      },
    ],
    'prefer-const': 1,
    'dot-notation': 0,
    'object-curly-newline': 0,
    'import/prefer-default-export': 0,
  },
};
