/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import io.flutter.view.ResourceExtractor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

public final class ResourceUpdater {
    private static final String TAG = "ResourceUpdater";
    private final Context context;
    private DownloadTask downloadTask;

    public ResourceUpdater(Context context) {
        this.context = context;
    }

    public String getAPKVersion() {
        try {
            PackageManager packageManager = this.context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(this.context.getPackageName(), 0);
            return packageInfo == null ? null : Long.toString(ResourceExtractor.getVersionCode(packageInfo));
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    public String getUpdateInstallationPath() {
        return this.context.getFilesDir().toString() + "/patch.zip";
    }

    public String buildUpdateDownloadURL() {
        URI uri;
        Bundle metaData;
        try {
            metaData = this.context.getPackageManager().getApplicationInfo((String)this.context.getPackageName(), (int)128).metaData;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (metaData == null || metaData.getString("PatchServerURL") == null) {
            return null;
        }
        try {
            uri = new URI(metaData.getString("PatchServerURL") + "/" + this.getAPKVersion() + ".zip");
        }
        catch (URISyntaxException e) {
            Log.w((String)TAG, (String)("Invalid AndroidManifest.xml PatchServerURL: " + e.getMessage()));
            return null;
        }
        return uri.normalize().toString();
    }

    public DownloadMode getDownloadMode() {
        Bundle metaData;
        try {
            metaData = this.context.getPackageManager().getApplicationInfo((String)this.context.getPackageName(), (int)128).metaData;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (metaData == null) {
            return DownloadMode.ON_RESTART;
        }
        String patchDownloadMode = metaData.getString("PatchDownloadMode");
        if (patchDownloadMode == null) {
            return DownloadMode.ON_RESTART;
        }
        try {
            return DownloadMode.valueOf(patchDownloadMode);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)("Invalid PatchDownloadMode " + patchDownloadMode));
            return DownloadMode.ON_RESTART;
        }
    }

    public InstallMode getInstallMode() {
        Bundle metaData;
        try {
            metaData = this.context.getPackageManager().getApplicationInfo((String)this.context.getPackageName(), (int)128).metaData;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (metaData == null) {
            return InstallMode.ON_NEXT_RESTART;
        }
        String patchInstallMode = metaData.getString("PatchInstallMode");
        if (patchInstallMode == null) {
            return InstallMode.ON_NEXT_RESTART;
        }
        try {
            return InstallMode.valueOf(patchInstallMode);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)("Invalid PatchInstallMode " + patchInstallMode));
            return InstallMode.ON_NEXT_RESTART;
        }
    }

    public void startUpdateDownloadOnce() {
        if (this.downloadTask != null) {
            return;
        }
        this.downloadTask = new DownloadTask();
        this.downloadTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{this.buildUpdateDownloadURL(), this.getUpdateInstallationPath()});
    }

    public void waitForDownloadCompletion() {
        if (this.downloadTask == null) {
            return;
        }
        try {
            this.downloadTask.get();
        }
        catch (CancellationException e) {
            Log.w((String)TAG, (String)("Download cancelled: " + e.getMessage()));
            return;
        }
        catch (ExecutionException e) {
            Log.w((String)TAG, (String)("Download exception: " + e.getMessage()));
            return;
        }
        catch (InterruptedException e) {
            Log.w((String)TAG, (String)("Download interrupted: " + e.getMessage()));
            return;
        }
    }

    private static class DownloadTask
    extends AsyncTask<String, String, Void> {
        private DownloadTask() {
        }

        /*
         * Exception decompiling
         */
        protected Void doInBackground(String ... args) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static enum InstallMode {
        ON_NEXT_RESTART,
        IMMEDIATE;

    }

    static enum DownloadMode {
        ON_RESTART,
        ON_RESUME;

    }
}

