/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.AsyncTask;
import android.os.Build;
import android.util.Log;
import io.flutter.util.PathUtils;
import io.flutter.view.FlutterMain;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Scanner;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.json.JSONException;
import org.json.JSONObject;

class ResourceExtractor {
    private static final String TAG = "ResourceExtractor";
    private static final String TIMESTAMP_PREFIX = "res_timestamp-";
    private static final int BUFFER_SIZE = 16384;
    private final Context mContext;
    private final HashSet<String> mResources;
    private ExtractTask mExtractTask;

    static long getVersionCode(PackageInfo packageInfo) {
        if (Build.VERSION.SDK_INT >= 28) {
            return packageInfo.getLongVersionCode();
        }
        return packageInfo.versionCode;
    }

    ResourceExtractor(Context context) {
        this.mContext = context;
        this.mResources = new HashSet();
    }

    ResourceExtractor addResource(String resource) {
        this.mResources.add(resource);
        return this;
    }

    ResourceExtractor addResources(Collection<String> resources) {
        this.mResources.addAll(resources);
        return this;
    }

    ResourceExtractor start() {
        assert (this.mExtractTask == null);
        this.mExtractTask = new ExtractTask();
        this.mExtractTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        return this;
    }

    void waitForCompletion() {
        if (this.mExtractTask == null) {
            return;
        }
        try {
            this.mExtractTask.get();
        }
        catch (CancellationException e) {
            this.deleteFiles();
        }
        catch (ExecutionException e2) {
            this.deleteFiles();
        }
        catch (InterruptedException e3) {
            this.deleteFiles();
        }
    }

    boolean filesMatch() {
        File dataDir;
        String timestamp;
        JSONObject updateManifest = this.readUpdateManifest();
        if (!this.validateUpdateManifest(updateManifest)) {
            updateManifest = null;
        }
        return (timestamp = this.checkTimestamp(dataDir = new File(PathUtils.getDataDirectory(this.mContext)), updateManifest)) == null;
    }

    private String[] getExistingTimestamps(File dataDir) {
        return dataDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(ResourceExtractor.TIMESTAMP_PREFIX);
            }
        });
    }

    private void deleteFiles() {
        File dataDir = new File(PathUtils.getDataDirectory(this.mContext));
        for (String resource : this.mResources) {
            File file = new File(dataDir, resource);
            if (!file.exists()) continue;
            file.delete();
        }
        String[] existingTimestamps = this.getExistingTimestamps(dataDir);
        if (existingTimestamps == null) {
            return;
        }
        for (String timestamp : existingTimestamps) {
            new File(dataDir, timestamp).delete();
        }
    }

    private boolean extractAPK(File dataDir) {
        AssetManager manager = this.mContext.getResources().getAssets();
        byte[] buffer = null;
        for (String asset : this.mResources) {
            try {
                File output = new File(dataDir, asset);
                if (output.exists()) continue;
                if (output.getParentFile() != null) {
                    output.getParentFile().mkdirs();
                }
                InputStream is = manager.open(asset);
                Throwable throwable = null;
                try {
                    FileOutputStream os = new FileOutputStream(output);
                    Throwable throwable2 = null;
                    try {
                        if (buffer == null) {
                            buffer = new byte[16384];
                        }
                        int count = 0;
                        while ((count = is.read(buffer, 0, 16384)) != -1) {
                            ((OutputStream)os).write(buffer, 0, count);
                        }
                        os.flush();
                        Log.i((String)TAG, (String)("Extracted baseline resource " + asset));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (os == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)os).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((OutputStream)os).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (FileNotFoundException fnfe) {
            }
            catch (IOException ioe) {
                Log.w((String)TAG, (String)("Exception unpacking resources: " + ioe.getMessage()));
                this.deleteFiles();
                return false;
            }
        }
        return true;
    }

    private boolean extractUpdate(File dataDir) {
        ZipFile zipFile;
        if (FlutterMain.getUpdateInstallationPath() == null) {
            return true;
        }
        File updateFile = new File(FlutterMain.getUpdateInstallationPath());
        if (!updateFile.exists()) {
            return true;
        }
        try {
            zipFile = new ZipFile(updateFile);
        }
        catch (ZipException e) {
            Log.w((String)TAG, (String)("Exception unpacking resources: " + e.getMessage()));
            this.deleteFiles();
            return false;
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)("Exception unpacking resources: " + e.getMessage()));
            this.deleteFiles();
            return false;
        }
        byte[] buffer = null;
        for (String asset : this.mResources) {
            File output;
            ZipEntry entry = zipFile.getEntry(asset);
            if (entry == null || (output = new File(dataDir, asset)).exists()) continue;
            if (output.getParentFile() != null) {
                output.getParentFile().mkdirs();
            }
            try {
                InputStream is = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileOutputStream os = new FileOutputStream(output);
                    Throwable throwable2 = null;
                    try {
                        if (buffer == null) {
                            buffer = new byte[16384];
                        }
                        int count = 0;
                        while ((count = is.read(buffer, 0, 16384)) != -1) {
                            ((OutputStream)os).write(buffer, 0, count);
                        }
                        os.flush();
                        Log.i((String)TAG, (String)("Extracted override resource " + asset));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (os == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)os).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((OutputStream)os).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (FileNotFoundException fnfe) {
            }
            catch (IOException ioe) {
                Log.w((String)TAG, (String)("Exception unpacking resources: " + ioe.getMessage()));
                this.deleteFiles();
                return false;
            }
        }
        return true;
    }

    private String checkTimestamp(File dataDir, JSONObject updateManifest) {
        String[] existingTimestamps;
        PackageManager packageManager = this.mContext.getPackageManager();
        PackageInfo packageInfo = null;
        try {
            packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return TIMESTAMP_PREFIX;
        }
        if (packageInfo == null) {
            return TIMESTAMP_PREFIX;
        }
        String expectedTimestamp = TIMESTAMP_PREFIX + ResourceExtractor.getVersionCode(packageInfo) + "-" + packageInfo.lastUpdateTime;
        if (updateManifest != null) {
            String buildNumber = updateManifest.optString("buildNumber", null);
            if (buildNumber == null) {
                Log.w((String)TAG, (String)"Invalid update manifest: buildNumber");
            } else {
                String patchNumber = updateManifest.optString("patchNumber", null);
                if (!buildNumber.equals(Long.toString(ResourceExtractor.getVersionCode(packageInfo)))) {
                    Log.w((String)TAG, (String)("Outdated update file for " + ResourceExtractor.getVersionCode(packageInfo)));
                } else {
                    File updateFile = new File(FlutterMain.getUpdateInstallationPath());
                    expectedTimestamp = patchNumber != null ? expectedTimestamp + "-" + patchNumber + "-" + updateFile.lastModified() : expectedTimestamp + "-" + updateFile.lastModified();
                }
            }
        }
        if ((existingTimestamps = this.getExistingTimestamps(dataDir)) == null) {
            Log.i((String)TAG, (String)"No extracted resources found");
            return expectedTimestamp;
        }
        if (existingTimestamps.length == 1) {
            Log.i((String)TAG, (String)("Found extracted resources " + existingTimestamps[0]));
        }
        if (existingTimestamps.length != 1 || !expectedTimestamp.equals(existingTimestamps[0])) {
            Log.i((String)TAG, (String)("Resource version mismatch " + expectedTimestamp));
            return expectedTimestamp;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateUpdateManifest(JSONObject updateManifest) {
        if (updateManifest == null) {
            return false;
        }
        String baselineChecksum = updateManifest.optString("baselineChecksum", null);
        if (baselineChecksum == null) {
            Log.w((String)TAG, (String)"Invalid update manifest: baselineChecksum");
            return false;
        }
        AssetManager manager = this.mContext.getResources().getAssets();
        try (InputStream is = manager.open("flutter_assets/isolate_snapshot_data");){
            CRC32 checksum = new CRC32();
            int count = 0;
            byte[] buffer = new byte[16384];
            while ((count = is.read(buffer, 0, 16384)) != -1) {
                checksum.update(buffer, 0, count);
            }
            if (!baselineChecksum.equals(String.valueOf(checksum.getValue()))) {
                Log.w((String)TAG, (String)"Mismatched update file for APK");
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)("Could not read APK: " + e));
            return false;
        }
    }

    private JSONObject readUpdateManifest() {
        if (FlutterMain.getUpdateInstallationPath() == null) {
            return null;
        }
        File updateFile = new File(FlutterMain.getUpdateInstallationPath());
        if (!updateFile.exists()) {
            return null;
        }
        try {
            ZipFile zipFile = new ZipFile(updateFile);
            ZipEntry entry = zipFile.getEntry("manifest.json");
            if (entry == null) {
                Log.w((String)TAG, (String)("Invalid update file: " + updateFile));
                return null;
            }
            Scanner scanner = new Scanner(zipFile.getInputStream(entry));
            return new JSONObject(scanner.useDelimiter("\\A").next());
        }
        catch (ZipException e) {
            Log.w((String)TAG, (String)("Invalid update file: " + e));
            return null;
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)("Invalid update file: " + e));
            return null;
        }
        catch (JSONException e) {
            Log.w((String)TAG, (String)("Invalid update file: " + (Object)((Object)e)));
            return null;
        }
    }

    private class ExtractTask
    extends AsyncTask<Void, Void, Void> {
        ExtractTask() {
        }

        protected Void doInBackground(Void ... unused) {
            String timestamp;
            File dataDir = new File(PathUtils.getDataDirectory(ResourceExtractor.this.mContext));
            JSONObject updateManifest = ResourceExtractor.this.readUpdateManifest();
            if (!ResourceExtractor.this.validateUpdateManifest(updateManifest)) {
                updateManifest = null;
            }
            if ((timestamp = ResourceExtractor.this.checkTimestamp(dataDir, updateManifest)) == null) {
                return null;
            }
            ResourceExtractor.this.deleteFiles();
            if (updateManifest != null && !ResourceExtractor.this.extractUpdate(dataDir)) {
                return null;
            }
            if (!ResourceExtractor.this.extractAPK(dataDir)) {
                return null;
            }
            if (timestamp != null) {
                try {
                    new File(dataDir, timestamp).createNewFile();
                }
                catch (IOException e) {
                    Log.w((String)ResourceExtractor.TAG, (String)"Failed to write resource timestamp");
                }
            }
            return null;
        }
    }
}

