/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.embedding.engine.FlutterEngine;
import java.util.HashMap;
import java.util.Map;

public class FlutterEngineCache {
    private static FlutterEngineCache instance;
    private final Map<String, FlutterEngine> cachedEngines = new HashMap<String, FlutterEngine>();

    @NonNull
    public static FlutterEngineCache getInstance() {
        if (instance == null) {
            instance = new FlutterEngineCache();
        }
        return instance;
    }

    @VisibleForTesting
    FlutterEngineCache() {
    }

    public boolean contains(@NonNull String engineId) {
        return this.cachedEngines.containsKey(engineId);
    }

    @Nullable
    public FlutterEngine get(@NonNull String engineId) {
        return this.cachedEngines.get(engineId);
    }

    public void put(@NonNull String engineId, @Nullable FlutterEngine engine) {
        if (engine != null) {
            this.cachedEngines.put(engineId, engine);
        } else {
            this.cachedEngines.remove(engineId);
        }
    }

    public void remove(@NonNull String engineId) {
        this.put(engineId, null);
    }
}

