/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.flutter.Log;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.JSONMethodCodec;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PlatformChannel {
    private static final String TAG = "PlatformChannel";
    @NonNull
    public final MethodChannel channel;
    @Nullable
    private PlatformMessageHandler platformMessageHandler;
    @NonNull
    @VisibleForTesting
    protected final MethodChannel.MethodCallHandler parsingMethodCallHandler = new MethodChannel.MethodCallHandler(){

        @Override
        public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            if (PlatformChannel.this.platformMessageHandler == null) {
                return;
            }
            String method = call.method;
            Object arguments = call.arguments;
            Log.v(PlatformChannel.TAG, "Received '" + method + "' message.");
            try {
                switch (method) {
                    case "SystemSound.play": {
                        try {
                            SoundType soundType = SoundType.fromValue((String)arguments);
                            PlatformChannel.this.platformMessageHandler.playSystemSound(soundType);
                            result.success(null);
                        }
                        catch (NoSuchFieldException exception) {
                            result.error("error", exception.getMessage(), null);
                        }
                        break;
                    }
                    case "HapticFeedback.vibrate": {
                        try {
                            HapticFeedbackType feedbackType = HapticFeedbackType.fromValue((String)arguments);
                            PlatformChannel.this.platformMessageHandler.vibrateHapticFeedback(feedbackType);
                            result.success(null);
                        }
                        catch (NoSuchFieldException exception) {
                            result.error("error", exception.getMessage(), null);
                        }
                        break;
                    }
                    case "SystemChrome.setPreferredOrientations": {
                        try {
                            int androidOrientation = PlatformChannel.this.decodeOrientations((JSONArray)arguments);
                            PlatformChannel.this.platformMessageHandler.setPreferredOrientations(androidOrientation);
                            result.success(null);
                        }
                        catch (NoSuchFieldException | JSONException exception) {
                            result.error("error", exception.getMessage(), null);
                        }
                        break;
                    }
                    case "SystemChrome.setApplicationSwitcherDescription": {
                        try {
                            AppSwitcherDescription description = PlatformChannel.this.decodeAppSwitcherDescription((JSONObject)arguments);
                            PlatformChannel.this.platformMessageHandler.setApplicationSwitcherDescription(description);
                            result.success(null);
                        }
                        catch (JSONException exception) {
                            result.error("error", exception.getMessage(), null);
                        }
                        break;
                    }
                    case "SystemChrome.setEnabledSystemUIOverlays": {
                        try {
                            List overlays = PlatformChannel.this.decodeSystemUiOverlays((JSONArray)arguments);
                            PlatformChannel.this.platformMessageHandler.showSystemOverlays(overlays);
                            result.success(null);
                        }
                        catch (NoSuchFieldException | JSONException exception) {
                            result.error("error", exception.getMessage(), null);
                        }
                        break;
                    }
                    case "SystemChrome.restoreSystemUIOverlays": {
                        PlatformChannel.this.platformMessageHandler.restoreSystemUiOverlays();
                        result.success(null);
                        break;
                    }
                    case "SystemChrome.setSystemUIOverlayStyle": {
                        try {
                            SystemChromeStyle systemChromeStyle = PlatformChannel.this.decodeSystemChromeStyle((JSONObject)arguments);
                            PlatformChannel.this.platformMessageHandler.setSystemUiOverlayStyle(systemChromeStyle);
                            result.success(null);
                        }
                        catch (NoSuchFieldException | JSONException exception) {
                            result.error("error", exception.getMessage(), null);
                        }
                        break;
                    }
                    case "SystemNavigator.pop": {
                        PlatformChannel.this.platformMessageHandler.popSystemNavigator();
                        result.success(null);
                        break;
                    }
                    case "Clipboard.getData": {
                        CharSequence clipboardContent;
                        String contentFormatName = (String)arguments;
                        ClipboardContentFormat clipboardFormat = null;
                        if (contentFormatName != null) {
                            try {
                                clipboardFormat = ClipboardContentFormat.fromValue(contentFormatName);
                            }
                            catch (NoSuchFieldException exception) {
                                result.error("error", "No such clipboard content format: " + contentFormatName, null);
                            }
                        }
                        if ((clipboardContent = PlatformChannel.this.platformMessageHandler.getClipboardData(clipboardFormat)) != null) {
                            JSONObject response = new JSONObject();
                            response.put("text", (Object)clipboardContent);
                            result.success(response);
                            break;
                        }
                        result.success(null);
                        break;
                    }
                    case "Clipboard.setData": {
                        String clipboardContent = ((JSONObject)arguments).getString("text");
                        PlatformChannel.this.platformMessageHandler.setClipboardData(clipboardContent);
                        result.success(null);
                        break;
                    }
                    default: {
                        result.notImplemented();
                        break;
                    }
                }
            }
            catch (JSONException e) {
                result.error("error", "JSON error: " + e.getMessage(), null);
            }
        }
    };

    public PlatformChannel(@NonNull DartExecutor dartExecutor) {
        this.channel = new MethodChannel(dartExecutor, "flutter/platform", JSONMethodCodec.INSTANCE);
        this.channel.setMethodCallHandler(this.parsingMethodCallHandler);
    }

    public void setPlatformMessageHandler(@Nullable PlatformMessageHandler platformMessageHandler) {
        this.platformMessageHandler = platformMessageHandler;
    }

    private int decodeOrientations(@NonNull JSONArray encodedOrientations) throws JSONException, NoSuchFieldException {
        int requestedOrientation = 0;
        int firstRequestedOrientation = 0;
        for (int index = 0; index < encodedOrientations.length(); ++index) {
            String encodedOrientation = encodedOrientations.getString(index);
            DeviceOrientation orientation = DeviceOrientation.fromValue(encodedOrientation);
            switch (orientation) {
                case PORTRAIT_UP: {
                    requestedOrientation |= 1;
                    break;
                }
                case PORTRAIT_DOWN: {
                    requestedOrientation |= 4;
                    break;
                }
                case LANDSCAPE_LEFT: {
                    requestedOrientation |= 2;
                    break;
                }
                case LANDSCAPE_RIGHT: {
                    requestedOrientation |= 8;
                }
            }
            if (firstRequestedOrientation != 0) continue;
            firstRequestedOrientation = requestedOrientation;
        }
        switch (requestedOrientation) {
            case 0: {
                return -1;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 4: {
                return 9;
            }
            case 5: {
                return 12;
            }
            case 8: {
                return 8;
            }
            case 10: {
                return 11;
            }
            case 11: {
                return 2;
            }
            case 15: {
                return 13;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                switch (firstRequestedOrientation) {
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 0;
                    }
                    case 4: {
                        return 9;
                    }
                    case 8: {
                        return 8;
                    }
                }
            }
        }
        return 1;
    }

    @NonNull
    private AppSwitcherDescription decodeAppSwitcherDescription(@NonNull JSONObject encodedDescription) throws JSONException {
        int color = encodedDescription.getInt("primaryColor");
        if (color != 0) {
            color |= 0xFF000000;
        }
        String label = encodedDescription.getString("label");
        return new AppSwitcherDescription(color, label);
    }

    @NonNull
    private List<SystemUiOverlay> decodeSystemUiOverlays(@NonNull JSONArray encodedSystemUiOverlay) throws JSONException, NoSuchFieldException {
        ArrayList<SystemUiOverlay> overlays = new ArrayList<SystemUiOverlay>();
        block4: for (int i = 0; i < encodedSystemUiOverlay.length(); ++i) {
            String encodedOverlay = encodedSystemUiOverlay.getString(i);
            SystemUiOverlay overlay = SystemUiOverlay.fromValue(encodedOverlay);
            switch (overlay) {
                case TOP_OVERLAYS: {
                    overlays.add(SystemUiOverlay.TOP_OVERLAYS);
                    continue block4;
                }
                case BOTTOM_OVERLAYS: {
                    overlays.add(SystemUiOverlay.BOTTOM_OVERLAYS);
                }
            }
        }
        return overlays;
    }

    @NonNull
    private SystemChromeStyle decodeSystemChromeStyle(@NonNull JSONObject encodedStyle) throws JSONException, NoSuchFieldException {
        Brightness systemNavigationBarIconBrightness = null;
        Integer systemNavigationBarColor = null;
        Integer systemNavigationBarDividerColor = null;
        Brightness statusBarIconBrightness = null;
        Integer statusBarColor = null;
        if (!encodedStyle.isNull("systemNavigationBarIconBrightness")) {
            systemNavigationBarIconBrightness = Brightness.fromValue(encodedStyle.getString("systemNavigationBarIconBrightness"));
        }
        if (!encodedStyle.isNull("systemNavigationBarColor")) {
            systemNavigationBarColor = encodedStyle.getInt("systemNavigationBarColor");
        }
        if (!encodedStyle.isNull("statusBarIconBrightness")) {
            statusBarIconBrightness = Brightness.fromValue(encodedStyle.getString("statusBarIconBrightness"));
        }
        if (!encodedStyle.isNull("statusBarColor")) {
            statusBarColor = encodedStyle.getInt("statusBarColor");
        }
        if (!encodedStyle.isNull("systemNavigationBarDividerColor")) {
            systemNavigationBarDividerColor = encodedStyle.getInt("systemNavigationBarDividerColor");
        }
        return new SystemChromeStyle(statusBarColor, statusBarIconBrightness, systemNavigationBarColor, systemNavigationBarIconBrightness, systemNavigationBarDividerColor);
    }

    public static enum ClipboardContentFormat {
        PLAIN_TEXT("text/plain");

        @NonNull
        private String encodedName;

        @NonNull
        static ClipboardContentFormat fromValue(@NonNull String encodedName) throws NoSuchFieldException {
            for (ClipboardContentFormat format : ClipboardContentFormat.values()) {
                if (!format.encodedName.equals(encodedName)) continue;
                return format;
            }
            throw new NoSuchFieldException("No such ClipboardContentFormat: " + encodedName);
        }

        private ClipboardContentFormat(String encodedName) {
            this.encodedName = encodedName;
        }
    }

    public static enum Brightness {
        LIGHT("Brightness.light"),
        DARK("Brightness.dark");

        @NonNull
        private String encodedName;

        @NonNull
        static Brightness fromValue(@NonNull String encodedName) throws NoSuchFieldException {
            for (Brightness brightness : Brightness.values()) {
                if (!brightness.encodedName.equals(encodedName)) continue;
                return brightness;
            }
            throw new NoSuchFieldException("No such Brightness: " + encodedName);
        }

        private Brightness(String encodedName) {
            this.encodedName = encodedName;
        }
    }

    public static class SystemChromeStyle {
        @Nullable
        public final Integer statusBarColor;
        @Nullable
        public final Brightness statusBarIconBrightness;
        @Nullable
        public final Integer systemNavigationBarColor;
        @Nullable
        public final Brightness systemNavigationBarIconBrightness;
        @Nullable
        public final Integer systemNavigationBarDividerColor;

        public SystemChromeStyle(@Nullable Integer statusBarColor, @Nullable Brightness statusBarIconBrightness, @Nullable Integer systemNavigationBarColor, @Nullable Brightness systemNavigationBarIconBrightness, @Nullable Integer systemNavigationBarDividerColor) {
            this.statusBarColor = statusBarColor;
            this.statusBarIconBrightness = statusBarIconBrightness;
            this.systemNavigationBarColor = systemNavigationBarColor;
            this.systemNavigationBarIconBrightness = systemNavigationBarIconBrightness;
            this.systemNavigationBarDividerColor = systemNavigationBarDividerColor;
        }
    }

    public static class AppSwitcherDescription {
        public final int color;
        @NonNull
        public final String label;

        public AppSwitcherDescription(int color, @NonNull String label) {
            this.color = color;
            this.label = label;
        }
    }

    public static enum SystemUiOverlay {
        TOP_OVERLAYS("SystemUiOverlay.top"),
        BOTTOM_OVERLAYS("SystemUiOverlay.bottom");

        @NonNull
        private String encodedName;

        @NonNull
        static SystemUiOverlay fromValue(@NonNull String encodedName) throws NoSuchFieldException {
            for (SystemUiOverlay overlay : SystemUiOverlay.values()) {
                if (!overlay.encodedName.equals(encodedName)) continue;
                return overlay;
            }
            throw new NoSuchFieldException("No such SystemUiOverlay: " + encodedName);
        }

        private SystemUiOverlay(String encodedName) {
            this.encodedName = encodedName;
        }
    }

    public static enum DeviceOrientation {
        PORTRAIT_UP("DeviceOrientation.portraitUp"),
        PORTRAIT_DOWN("DeviceOrientation.portraitDown"),
        LANDSCAPE_LEFT("DeviceOrientation.landscapeLeft"),
        LANDSCAPE_RIGHT("DeviceOrientation.landscapeRight");

        @NonNull
        private String encodedName;

        @NonNull
        static DeviceOrientation fromValue(@NonNull String encodedName) throws NoSuchFieldException {
            for (DeviceOrientation orientation : DeviceOrientation.values()) {
                if (!orientation.encodedName.equals(encodedName)) continue;
                return orientation;
            }
            throw new NoSuchFieldException("No such DeviceOrientation: " + encodedName);
        }

        private DeviceOrientation(String encodedName) {
            this.encodedName = encodedName;
        }
    }

    public static enum HapticFeedbackType {
        STANDARD(null),
        LIGHT_IMPACT("HapticFeedbackType.lightImpact"),
        MEDIUM_IMPACT("HapticFeedbackType.mediumImpact"),
        HEAVY_IMPACT("HapticFeedbackType.heavyImpact"),
        SELECTION_CLICK("HapticFeedbackType.selectionClick");

        @Nullable
        private final String encodedName;

        @NonNull
        static HapticFeedbackType fromValue(@Nullable String encodedName) throws NoSuchFieldException {
            for (HapticFeedbackType feedbackType : HapticFeedbackType.values()) {
                if ((feedbackType.encodedName != null || encodedName != null) && (feedbackType.encodedName == null || !feedbackType.encodedName.equals(encodedName))) continue;
                return feedbackType;
            }
            throw new NoSuchFieldException("No such HapticFeedbackType: " + encodedName);
        }

        private HapticFeedbackType(String encodedName) {
            this.encodedName = encodedName;
        }
    }

    public static enum SoundType {
        CLICK("SystemSoundType.click");

        @NonNull
        private final String encodedName;

        @NonNull
        static SoundType fromValue(@NonNull String encodedName) throws NoSuchFieldException {
            for (SoundType soundType : SoundType.values()) {
                if (!soundType.encodedName.equals(encodedName)) continue;
                return soundType;
            }
            throw new NoSuchFieldException("No such SoundType: " + encodedName);
        }

        private SoundType(String encodedName) {
            this.encodedName = encodedName;
        }
    }

    public static interface PlatformMessageHandler {
        public void playSystemSound(@NonNull SoundType var1);

        public void vibrateHapticFeedback(@NonNull HapticFeedbackType var1);

        public void setPreferredOrientations(int var1);

        public void setApplicationSwitcherDescription(@NonNull AppSwitcherDescription var1);

        public void showSystemOverlays(@NonNull List<SystemUiOverlay> var1);

        public void restoreSystemUiOverlays();

        public void setSystemUiOverlayStyle(@NonNull SystemChromeStyle var1);

        public void popSystemNavigator();

        @Nullable
        public CharSequence getClipboardData(@Nullable ClipboardContentFormat var1);

        public void setClipboardData(@NonNull String var1);
    }
}

