/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.app;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import io.flutter.app.FlutterActivityEvents;
import io.flutter.app.FlutterApplication;
import io.flutter.plugin.common.PluginRegistry;
import io.flutter.util.Preconditions;
import io.flutter.view.FlutterMain;
import io.flutter.view.FlutterNativeView;
import io.flutter.view.FlutterRunArguments;
import io.flutter.view.FlutterView;
import java.util.ArrayList;

public final class FlutterActivityDelegate
implements FlutterActivityEvents,
FlutterView.Provider,
PluginRegistry {
    private static final String SPLASH_SCREEN_META_DATA_KEY = "io.flutter.app.android.SplashScreenUntilFirstFrame";
    private static final String TAG = "FlutterActivityDelegate";
    private static final WindowManager.LayoutParams matchParent = new WindowManager.LayoutParams(-1, -1);
    private final Activity activity;
    private final ViewFactory viewFactory;
    private FlutterView flutterView;
    private View launchView;

    public FlutterActivityDelegate(Activity activity, ViewFactory viewFactory) {
        this.activity = Preconditions.checkNotNull(activity);
        this.viewFactory = Preconditions.checkNotNull(viewFactory);
    }

    @Override
    public FlutterView getFlutterView() {
        return this.flutterView;
    }

    @Override
    public boolean hasPlugin(String key) {
        return this.flutterView.getPluginRegistry().hasPlugin(key);
    }

    @Override
    public <T> T valuePublishedByPlugin(String pluginKey) {
        return this.flutterView.getPluginRegistry().valuePublishedByPlugin(pluginKey);
    }

    @Override
    public PluginRegistry.Registrar registrarFor(String pluginKey) {
        return this.flutterView.getPluginRegistry().registrarFor(pluginKey);
    }

    @Override
    public boolean onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        return this.flutterView.getPluginRegistry().onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    @Override
    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        return this.flutterView.getPluginRegistry().onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        String appBundlePath;
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.activity.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0x40000000);
            window.getDecorView().setSystemUiVisibility(1280);
        }
        String[] args = FlutterActivityDelegate.getArgsFromIntent(this.activity.getIntent());
        FlutterMain.ensureInitializationComplete(this.activity.getApplicationContext(), args);
        this.flutterView = this.viewFactory.createFlutterView((Context)this.activity);
        if (this.flutterView == null) {
            FlutterNativeView nativeView = this.viewFactory.createFlutterNativeView();
            this.flutterView = new FlutterView((Context)this.activity, null, nativeView);
            this.flutterView.setLayoutParams((ViewGroup.LayoutParams)matchParent);
            this.activity.setContentView((View)this.flutterView);
            this.launchView = this.createLaunchView();
            if (this.launchView != null) {
                this.addLaunchView();
            }
        }
        if (this.loadIntent(this.activity.getIntent())) {
            return;
        }
        if (!this.flutterView.getFlutterNativeView().isApplicationRunning() && (appBundlePath = FlutterMain.findAppBundlePath(this.activity.getApplicationContext())) != null) {
            FlutterRunArguments arguments = new FlutterRunArguments();
            ArrayList<String> bundlePaths = new ArrayList<String>();
            if (FlutterMain.getUpdateInstallationPath() != null) {
                bundlePaths.add(FlutterMain.getUpdateInstallationPath());
            }
            bundlePaths.add(appBundlePath);
            arguments.bundlePaths = bundlePaths.toArray(new String[0]);
            arguments.entrypoint = "main";
            this.flutterView.runFromBundle(arguments);
        }
    }

    @Override
    public void onNewIntent(Intent intent) {
        if (!this.isDebuggable() || !this.loadIntent(intent)) {
            this.flutterView.getPluginRegistry().onNewIntent(intent);
        }
    }

    private boolean isDebuggable() {
        return (this.activity.getApplicationInfo().flags & 2) != 0;
    }

    @Override
    public void onPause() {
        FlutterApplication flutterApp;
        Application app = (Application)this.activity.getApplicationContext();
        if (app instanceof FlutterApplication && this.activity.equals((flutterApp = (FlutterApplication)app).getCurrentActivity())) {
            flutterApp.setCurrentActivity(null);
        }
        if (this.flutterView != null) {
            this.flutterView.onPause();
        }
    }

    @Override
    public void onStart() {
        if (this.flutterView != null) {
            this.flutterView.onStart();
        }
    }

    @Override
    public void onResume() {
        Application app = (Application)this.activity.getApplicationContext();
        FlutterMain.onResume((Context)app);
        if (app instanceof FlutterApplication) {
            FlutterApplication flutterApp = (FlutterApplication)app;
            flutterApp.setCurrentActivity(this.activity);
        }
    }

    @Override
    public void onStop() {
        this.flutterView.onStop();
    }

    @Override
    public void onPostResume() {
        if (this.flutterView != null) {
            this.flutterView.onPostResume();
        }
    }

    @Override
    public void onDestroy() {
        FlutterApplication flutterApp;
        Application app = (Application)this.activity.getApplicationContext();
        if (app instanceof FlutterApplication && this.activity.equals((flutterApp = (FlutterApplication)app).getCurrentActivity())) {
            flutterApp.setCurrentActivity(null);
        }
        if (this.flutterView != null) {
            boolean detach = this.flutterView.getPluginRegistry().onViewDestroy(this.flutterView.getFlutterNativeView());
            if (detach || this.viewFactory.retainFlutterNativeView()) {
                this.flutterView.detach();
            } else {
                this.flutterView.destroy();
            }
        }
    }

    @Override
    public boolean onBackPressed() {
        if (this.flutterView != null) {
            this.flutterView.popRoute();
            return true;
        }
        return false;
    }

    @Override
    public void onUserLeaveHint() {
        this.flutterView.getPluginRegistry().onUserLeaveHint();
    }

    public void onTrimMemory(int level) {
        if (level == 10) {
            this.flutterView.onMemoryPressure();
        }
    }

    public void onLowMemory() {
        this.flutterView.onMemoryPressure();
    }

    public void onConfigurationChanged(Configuration newConfig) {
    }

    private static String[] getArgsFromIntent(Intent intent) {
        ArrayList<String> args = new ArrayList<String>();
        if (intent.getBooleanExtra("trace-startup", false)) {
            args.add("--trace-startup");
        }
        if (intent.getBooleanExtra("start-paused", false)) {
            args.add("--start-paused");
        }
        if (intent.getBooleanExtra("use-test-fonts", false)) {
            args.add("--use-test-fonts");
        }
        if (intent.getBooleanExtra("enable-dart-profiling", false)) {
            args.add("--enable-dart-profiling");
        }
        if (intent.getBooleanExtra("enable-software-rendering", false)) {
            args.add("--enable-software-rendering");
        }
        if (intent.getBooleanExtra("skia-deterministic-rendering", false)) {
            args.add("--skia-deterministic-rendering");
        }
        if (intent.getBooleanExtra("trace-skia", false)) {
            args.add("--trace-skia");
        }
        if (intent.getBooleanExtra("verbose-logging", false)) {
            args.add("--verbose-logging");
        }
        if (!args.isEmpty()) {
            String[] argsArray = new String[args.size()];
            return args.toArray(argsArray);
        }
        return null;
    }

    private boolean loadIntent(Intent intent) {
        String action = intent.getAction();
        if ("android.intent.action.RUN".equals(action)) {
            String route = intent.getStringExtra("route");
            String appBundlePath = intent.getDataString();
            if (appBundlePath == null) {
                appBundlePath = FlutterMain.findAppBundlePath(this.activity.getApplicationContext());
            }
            if (route != null) {
                this.flutterView.setInitialRoute(route);
            }
            if (!this.flutterView.getFlutterNativeView().isApplicationRunning()) {
                FlutterRunArguments args = new FlutterRunArguments();
                ArrayList<String> bundlePaths = new ArrayList<String>();
                if (FlutterMain.getUpdateInstallationPath() != null) {
                    bundlePaths.add(FlutterMain.getUpdateInstallationPath());
                }
                bundlePaths.add(appBundlePath);
                args.bundlePaths = bundlePaths.toArray(new String[0]);
                args.entrypoint = "main";
                this.flutterView.runFromBundle(args);
            }
            return true;
        }
        return false;
    }

    private View createLaunchView() {
        if (!this.showSplashScreenUntilFirstFrame().booleanValue()) {
            return null;
        }
        Drawable launchScreenDrawable = this.getLaunchScreenDrawableFromActivityTheme();
        if (launchScreenDrawable == null) {
            return null;
        }
        View view = new View((Context)this.activity);
        view.setLayoutParams((ViewGroup.LayoutParams)matchParent);
        view.setBackground(launchScreenDrawable);
        return view;
    }

    private Drawable getLaunchScreenDrawableFromActivityTheme() {
        TypedValue typedValue = new TypedValue();
        if (!this.activity.getTheme().resolveAttribute(16842836, typedValue, true)) {
            return null;
        }
        if (typedValue.resourceId == 0) {
            return null;
        }
        try {
            return this.activity.getResources().getDrawable(typedValue.resourceId);
        }
        catch (Resources.NotFoundException e) {
            Log.e((String)TAG, (String)"Referenced launch screen windowBackground resource does not exist");
            return null;
        }
    }

    private Boolean showSplashScreenUntilFirstFrame() {
        try {
            ActivityInfo activityInfo = this.activity.getPackageManager().getActivityInfo(this.activity.getComponentName(), 129);
            Bundle metadata = activityInfo.metaData;
            return metadata != null && metadata.getBoolean(SPLASH_SCREEN_META_DATA_KEY);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    private void addLaunchView() {
        if (this.launchView == null) {
            return;
        }
        this.activity.addContentView(this.launchView, (ViewGroup.LayoutParams)matchParent);
        this.flutterView.addFirstFrameListener(new FlutterView.FirstFrameListener(){

            @Override
            public void onFirstFrame() {
                FlutterActivityDelegate.this.launchView.animate().alpha(0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        ((ViewGroup)FlutterActivityDelegate.this.launchView.getParent()).removeView(FlutterActivityDelegate.this.launchView);
                        FlutterActivityDelegate.this.launchView = null;
                    }
                });
                FlutterActivityDelegate.this.flutterView.removeFirstFrameListener(this);
            }
        });
        this.activity.setTheme(16973833);
    }

    public static interface ViewFactory {
        public FlutterView createFlutterView(Context var1);

        public FlutterNativeView createFlutterNativeView();

        public boolean retainFlutterNativeView();
    }
}

