/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.view;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import io.flutter.app.FlutterPluginRegistry;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.dart.PlatformMessageHandler;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.view.FlutterRunArguments;
import io.flutter.view.FlutterView;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class FlutterNativeView
implements BinaryMessenger {
    private static final String TAG = "FlutterNativeView";
    private final Map<String, BinaryMessenger.BinaryMessageHandler> mMessageHandlers;
    private int mNextReplyId = 1;
    private final Map<Integer, BinaryMessenger.BinaryReply> mPendingReplies = new HashMap<Integer, BinaryMessenger.BinaryReply>();
    private final FlutterPluginRegistry mPluginRegistry;
    private FlutterView mFlutterView;
    private FlutterJNI mFlutterJNI;
    private final Context mContext;
    private boolean applicationIsRunning;

    public FlutterNativeView(Context context) {
        this(context, false);
    }

    public FlutterNativeView(Context context, boolean isBackgroundView) {
        this.mContext = context;
        this.mPluginRegistry = new FlutterPluginRegistry(this, context);
        this.mFlutterJNI = new FlutterJNI();
        this.mFlutterJNI.setRenderSurface(new RenderSurfaceImpl());
        this.mFlutterJNI.setPlatformMessageHandler(new PlatformMessageHandlerImpl());
        this.mFlutterJNI.addEngineLifecycleListener(new EngineLifecycleListenerImpl());
        this.attach(this, isBackgroundView);
        this.assertAttached();
        this.mMessageHandlers = new HashMap<String, BinaryMessenger.BinaryMessageHandler>();
    }

    public void detach() {
        this.mPluginRegistry.detach();
        this.mFlutterView = null;
        this.mFlutterJNI.detachFromNativeButKeepNativeResources();
    }

    public void destroy() {
        this.mPluginRegistry.destroy();
        this.mFlutterView = null;
        this.mFlutterJNI.detachFromNativeAndReleaseResources();
        this.applicationIsRunning = false;
    }

    public FlutterPluginRegistry getPluginRegistry() {
        return this.mPluginRegistry;
    }

    public void attachViewAndActivity(FlutterView flutterView, Activity activity) {
        this.mFlutterView = flutterView;
        this.mPluginRegistry.attach(flutterView, activity);
    }

    public boolean isAttached() {
        return this.mFlutterJNI.isAttached();
    }

    public void assertAttached() {
        if (!this.isAttached()) {
            throw new AssertionError((Object)"Platform view is not attached");
        }
    }

    public void runFromBundle(FlutterRunArguments args) {
        boolean hasBundlePaths;
        boolean bl = hasBundlePaths = args.bundlePaths != null && args.bundlePaths.length != 0;
        if (args.bundlePath == null && !hasBundlePaths) {
            throw new AssertionError((Object)"Either bundlePath or bundlePaths must be specified");
        }
        if ((args.bundlePath != null || args.defaultPath != null) && hasBundlePaths) {
            throw new AssertionError((Object)"Can't specify both bundlePath and bundlePaths");
        }
        if (args.entrypoint == null) {
            throw new AssertionError((Object)"An entrypoint must be specified");
        }
        if (hasBundlePaths) {
            this.runFromBundleInternal(args.bundlePaths, args.entrypoint, args.libraryPath);
        } else {
            this.runFromBundleInternal(new String[]{args.bundlePath, args.defaultPath}, args.entrypoint, args.libraryPath);
        }
    }

    @Deprecated
    public void runFromBundle(String bundlePath, String defaultPath, String entrypoint, boolean reuseRuntimeController) {
        this.runFromBundleInternal(new String[]{bundlePath, defaultPath}, entrypoint, null);
    }

    private void runFromBundleInternal(String[] bundlePaths, String entrypoint, String libraryPath) {
        this.assertAttached();
        if (this.applicationIsRunning) {
            throw new AssertionError((Object)"This Flutter engine instance is already running an application");
        }
        this.mFlutterJNI.runBundleAndSnapshotFromLibrary(bundlePaths, entrypoint, libraryPath, this.mContext.getResources().getAssets());
        this.applicationIsRunning = true;
    }

    public boolean isApplicationRunning() {
        return this.applicationIsRunning;
    }

    public static String getObservatoryUri() {
        return FlutterJNI.nativeGetObservatoryUri();
    }

    @Override
    public void send(String channel, ByteBuffer message) {
        this.send(channel, message, null);
    }

    @Override
    public void send(String channel, ByteBuffer message, BinaryMessenger.BinaryReply callback) {
        if (!this.isAttached()) {
            Log.d((String)TAG, (String)("FlutterView.send called on a detached view, channel=" + channel));
            return;
        }
        int replyId = 0;
        if (callback != null) {
            replyId = this.mNextReplyId++;
            this.mPendingReplies.put(replyId, callback);
        }
        if (message == null) {
            this.mFlutterJNI.dispatchEmptyPlatformMessage(channel, replyId);
        } else {
            this.mFlutterJNI.dispatchPlatformMessage(channel, message, message.position(), replyId);
        }
    }

    @Override
    public void setMessageHandler(String channel, BinaryMessenger.BinaryMessageHandler handler) {
        if (handler == null) {
            this.mMessageHandlers.remove(channel);
        } else {
            this.mMessageHandlers.put(channel, handler);
        }
    }

    FlutterJNI getFlutterJNI() {
        return this.mFlutterJNI;
    }

    private void attach(FlutterNativeView view, boolean isBackgroundView) {
        this.mFlutterJNI.attachToNative(isBackgroundView);
    }

    private final class EngineLifecycleListenerImpl
    implements FlutterEngine.EngineLifecycleListener {
        private EngineLifecycleListenerImpl() {
        }

        @Override
        public void onPreEngineRestart() {
            if (FlutterNativeView.this.mFlutterView != null) {
                FlutterNativeView.this.mFlutterView.resetAccessibilityTree();
            }
            if (FlutterNativeView.this.mPluginRegistry == null) {
                return;
            }
            FlutterNativeView.this.mPluginRegistry.onPreEngineRestart();
        }
    }

    private final class RenderSurfaceImpl
    implements FlutterRenderer.RenderSurface {
        private RenderSurfaceImpl() {
        }

        @Override
        public void updateSemantics(ByteBuffer buffer, String[] strings) {
            if (FlutterNativeView.this.mFlutterView == null) {
                return;
            }
            FlutterNativeView.this.mFlutterView.updateSemantics(buffer, strings);
        }

        @Override
        public void updateCustomAccessibilityActions(ByteBuffer buffer, String[] strings) {
            if (FlutterNativeView.this.mFlutterView == null) {
                return;
            }
            FlutterNativeView.this.mFlutterView.updateCustomAccessibilityActions(buffer, strings);
        }

        @Override
        public void onFirstFrameRendered() {
            if (FlutterNativeView.this.mFlutterView == null) {
                return;
            }
            FlutterNativeView.this.mFlutterView.onFirstFrame();
        }
    }

    private final class PlatformMessageHandlerImpl
    implements PlatformMessageHandler {
        private PlatformMessageHandlerImpl() {
        }

        @Override
        public void handlePlatformMessage(final String channel, byte[] message, final int replyId) {
            FlutterNativeView.this.assertAttached();
            BinaryMessenger.BinaryMessageHandler handler = (BinaryMessenger.BinaryMessageHandler)FlutterNativeView.this.mMessageHandlers.get(channel);
            if (handler != null) {
                try {
                    ByteBuffer buffer = message == null ? null : ByteBuffer.wrap(message);
                    handler.onMessage(buffer, new BinaryMessenger.BinaryReply(){
                        private final AtomicBoolean done = new AtomicBoolean(false);

                        @Override
                        public void reply(ByteBuffer reply) {
                            if (!FlutterNativeView.this.isAttached()) {
                                Log.d((String)FlutterNativeView.TAG, (String)("handlePlatformMessage replying ot a detached view, channel=" + channel));
                                return;
                            }
                            if (this.done.getAndSet(true)) {
                                throw new IllegalStateException("Reply already submitted");
                            }
                            if (reply == null) {
                                FlutterNativeView.this.mFlutterJNI.invokePlatformMessageEmptyResponseCallback(replyId);
                            } else {
                                FlutterNativeView.this.mFlutterJNI.invokePlatformMessageResponseCallback(replyId, reply, reply.position());
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    Log.e((String)FlutterNativeView.TAG, (String)"Uncaught exception in binary message listener", (Throwable)exception);
                    FlutterNativeView.this.mFlutterJNI.invokePlatformMessageEmptyResponseCallback(replyId);
                }
                return;
            }
            FlutterNativeView.this.mFlutterJNI.invokePlatformMessageEmptyResponseCallback(replyId);
        }

        @Override
        public void handlePlatformMessageResponse(int replyId, byte[] reply) {
            BinaryMessenger.BinaryReply callback = (BinaryMessenger.BinaryReply)FlutterNativeView.this.mPendingReplies.remove(replyId);
            if (callback != null) {
                try {
                    callback.reply(reply == null ? null : ByteBuffer.wrap(reply));
                }
                catch (Exception ex) {
                    Log.e((String)FlutterNativeView.TAG, (String)"Uncaught exception in binary message reply handler", (Throwable)ex);
                }
            }
        }
    }
}

