/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.android;

import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.embedding.engine.systemchannels.KeyEventChannel;
import io.flutter.plugin.editing.TextInputPlugin;

public class AndroidKeyProcessor {
    @NonNull
    private final KeyEventChannel keyEventChannel;
    @NonNull
    private final TextInputPlugin textInputPlugin;
    private int combiningCharacter;

    public AndroidKeyProcessor(@NonNull KeyEventChannel keyEventChannel, @NonNull TextInputPlugin textInputPlugin) {
        this.keyEventChannel = keyEventChannel;
        this.textInputPlugin = textInputPlugin;
    }

    public void onKeyUp(@NonNull KeyEvent keyEvent) {
        Character complexCharacter = this.applyCombiningCharacterToBaseCharacter(keyEvent.getUnicodeChar());
        this.keyEventChannel.keyUp(new KeyEventChannel.FlutterKeyEvent(keyEvent, complexCharacter));
    }

    public void onKeyDown(@NonNull KeyEvent keyEvent) {
        if (this.textInputPlugin.getLastInputConnection() != null && this.textInputPlugin.getInputMethodManager().isAcceptingText()) {
            this.textInputPlugin.getLastInputConnection().sendKeyEvent(keyEvent);
        }
        Character complexCharacter = this.applyCombiningCharacterToBaseCharacter(keyEvent.getUnicodeChar());
        this.keyEventChannel.keyDown(new KeyEventChannel.FlutterKeyEvent(keyEvent, complexCharacter));
    }

    @Nullable
    private Character applyCombiningCharacterToBaseCharacter(int newCharacterCodePoint) {
        boolean isNewCodePointACombiningCharacter;
        if (newCharacterCodePoint == 0) {
            return null;
        }
        Character complexCharacter = Character.valueOf((char)newCharacterCodePoint);
        boolean bl = isNewCodePointACombiningCharacter = (newCharacterCodePoint & Integer.MIN_VALUE) != 0;
        if (isNewCodePointACombiningCharacter) {
            int plainCodePoint = newCharacterCodePoint & Integer.MAX_VALUE;
            this.combiningCharacter = this.combiningCharacter != 0 ? KeyCharacterMap.getDeadChar((int)this.combiningCharacter, (int)plainCodePoint) : plainCodePoint;
        } else if (this.combiningCharacter != 0) {
            int combinedChar = KeyCharacterMap.getDeadChar((int)this.combiningCharacter, (int)newCharacterCodePoint);
            if (combinedChar > 0) {
                complexCharacter = Character.valueOf((char)combinedChar);
            }
            this.combiningCharacter = 0;
        }
        return complexCharacter;
    }
}

