/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.view.Surface;
import io.flutter.embedding.engine.FlutterEngine;
import io.flutter.embedding.engine.dart.PlatformMessageHandler;
import io.flutter.embedding.engine.renderer.FlutterRenderer;
import io.flutter.embedding.engine.renderer.OnFirstFrameRenderedListener;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;

public class FlutterJNI {
    private static final String TAG = "FlutterJNI";
    private Long nativePlatformViewId;
    private FlutterRenderer.RenderSurface renderSurface;
    private PlatformMessageHandler platformMessageHandler;
    private final Set<FlutterEngine.EngineLifecycleListener> engineLifecycleListeners = new HashSet<FlutterEngine.EngineLifecycleListener>();
    private final Set<OnFirstFrameRenderedListener> firstFrameListeners = new HashSet<OnFirstFrameRenderedListener>();

    @UiThread
    public static native boolean nativeGetIsSoftwareRenderingEnabled();

    @UiThread
    public static native String nativeGetObservatoryUri();

    @UiThread
    public void setRenderSurface(@Nullable FlutterRenderer.RenderSurface renderSurface) {
        this.renderSurface = renderSurface;
    }

    @UiThread
    private void updateSemantics(ByteBuffer buffer, String[] strings) {
        if (this.renderSurface != null) {
            this.renderSurface.updateSemantics(buffer, strings);
        }
    }

    @UiThread
    private void updateCustomAccessibilityActions(ByteBuffer buffer, String[] strings) {
        if (this.renderSurface != null) {
            this.renderSurface.updateCustomAccessibilityActions(buffer, strings);
        }
    }

    @UiThread
    private void onFirstFrame() {
        if (this.renderSurface != null) {
            this.renderSurface.onFirstFrameRendered();
        }
        for (OnFirstFrameRenderedListener listener : this.firstFrameListeners) {
            listener.onFirstFrameRendered();
        }
    }

    @UiThread
    public void setPlatformMessageHandler(@Nullable PlatformMessageHandler platformMessageHandler) {
        this.platformMessageHandler = platformMessageHandler;
    }

    private void handlePlatformMessage(String channel, byte[] message, int replyId) {
        if (this.platformMessageHandler != null) {
            this.platformMessageHandler.handlePlatformMessage(channel, message, replyId);
        }
    }

    private void handlePlatformMessageResponse(int replyId, byte[] reply) {
        if (this.platformMessageHandler != null) {
            this.platformMessageHandler.handlePlatformMessageResponse(replyId, reply);
        }
    }

    @UiThread
    public void addEngineLifecycleListener(@NonNull FlutterEngine.EngineLifecycleListener engineLifecycleListener) {
        this.engineLifecycleListeners.add(engineLifecycleListener);
    }

    @UiThread
    public void removeEngineLifecycleListener(@NonNull FlutterEngine.EngineLifecycleListener engineLifecycleListener) {
        this.engineLifecycleListeners.remove(engineLifecycleListener);
    }

    @UiThread
    public void addOnFirstFrameRenderedListener(@NonNull OnFirstFrameRenderedListener listener) {
        this.firstFrameListeners.add(listener);
    }

    @UiThread
    public void removeOnFirstFrameRenderedListener(@NonNull OnFirstFrameRenderedListener listener) {
        this.firstFrameListeners.remove(listener);
    }

    @UiThread
    public void onSurfaceCreated(@NonNull Surface surface) {
        this.ensureAttachedToNative();
        this.nativeSurfaceCreated(this.nativePlatformViewId, surface);
    }

    private native void nativeSurfaceCreated(long var1, Surface var3);

    @UiThread
    public void onSurfaceChanged(int width, int height) {
        this.ensureAttachedToNative();
        this.nativeSurfaceChanged(this.nativePlatformViewId, width, height);
    }

    private native void nativeSurfaceChanged(long var1, int var3, int var4);

    @UiThread
    public void onSurfaceDestroyed() {
        this.ensureAttachedToNative();
        this.nativeSurfaceDestroyed(this.nativePlatformViewId);
    }

    private native void nativeSurfaceDestroyed(long var1);

    @UiThread
    public void setViewportMetrics(float devicePixelRatio, int physicalWidth, int physicalHeight, int physicalPaddingTop, int physicalPaddingRight, int physicalPaddingBottom, int physicalPaddingLeft, int physicalViewInsetTop, int physicalViewInsetRight, int physicalViewInsetBottom, int physicalViewInsetLeft) {
        this.ensureAttachedToNative();
        this.nativeSetViewportMetrics(this.nativePlatformViewId, devicePixelRatio, physicalWidth, physicalHeight, physicalPaddingTop, physicalPaddingRight, physicalPaddingBottom, physicalPaddingLeft, physicalViewInsetTop, physicalViewInsetRight, physicalViewInsetBottom, physicalViewInsetLeft);
    }

    private native void nativeSetViewportMetrics(long var1, float var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13);

    @UiThread
    public Bitmap getBitmap() {
        this.ensureAttachedToNative();
        return this.nativeGetBitmap(this.nativePlatformViewId);
    }

    private native Bitmap nativeGetBitmap(long var1);

    @UiThread
    public void dispatchPointerDataPacket(ByteBuffer buffer, int position) {
        this.ensureAttachedToNative();
        this.nativeDispatchPointerDataPacket(this.nativePlatformViewId, buffer, position);
    }

    private native void nativeDispatchPointerDataPacket(long var1, ByteBuffer var3, int var4);

    @UiThread
    public void dispatchSemanticsAction(int id, int action, ByteBuffer args, int argsPosition) {
        this.ensureAttachedToNative();
        this.nativeDispatchSemanticsAction(this.nativePlatformViewId, id, action, args, argsPosition);
    }

    private native void nativeDispatchSemanticsAction(long var1, int var3, int var4, ByteBuffer var5, int var6);

    @UiThread
    public void setSemanticsEnabled(boolean enabled) {
        this.ensureAttachedToNative();
        this.nativeSetSemanticsEnabled(this.nativePlatformViewId, enabled);
    }

    private native void nativeSetSemanticsEnabled(long var1, boolean var3);

    @UiThread
    public void setAccessibilityFeatures(int flags) {
        this.ensureAttachedToNative();
        this.nativeSetAccessibilityFeatures(this.nativePlatformViewId, flags);
    }

    private native void nativeSetAccessibilityFeatures(long var1, int var3);

    @UiThread
    public void registerTexture(long textureId, SurfaceTexture surfaceTexture) {
        this.ensureAttachedToNative();
        this.nativeRegisterTexture(this.nativePlatformViewId, textureId, surfaceTexture);
    }

    private native void nativeRegisterTexture(long var1, long var3, SurfaceTexture var5);

    @UiThread
    public void markTextureFrameAvailable(long textureId) {
        this.ensureAttachedToNative();
        this.nativeMarkTextureFrameAvailable(this.nativePlatformViewId, textureId);
    }

    private native void nativeMarkTextureFrameAvailable(long var1, long var3);

    @UiThread
    public void unregisterTexture(long textureId) {
        this.ensureAttachedToNative();
        this.nativeUnregisterTexture(this.nativePlatformViewId, textureId);
    }

    private native void nativeUnregisterTexture(long var1, long var3);

    public boolean isAttached() {
        return this.nativePlatformViewId != null;
    }

    @UiThread
    public void attachToNative(boolean isBackgroundView) {
        this.ensureNotAttachedToNative();
        this.nativePlatformViewId = this.nativeAttach(this, isBackgroundView);
    }

    private native long nativeAttach(FlutterJNI var1, boolean var2);

    @UiThread
    public void detachFromNativeButKeepNativeResources() {
        this.ensureAttachedToNative();
        this.nativeDetach(this.nativePlatformViewId);
        this.nativePlatformViewId = null;
    }

    private native void nativeDetach(long var1);

    @UiThread
    public void detachFromNativeAndReleaseResources() {
        this.ensureAttachedToNative();
        this.nativeDestroy(this.nativePlatformViewId);
        this.nativePlatformViewId = null;
    }

    private native void nativeDestroy(long var1);

    @UiThread
    public void runBundleAndSnapshotFromLibrary(@NonNull String[] prioritizedBundlePaths, @Nullable String entrypointFunctionName, @Nullable String pathToEntrypointFunction, @NonNull AssetManager assetManager) {
        this.ensureAttachedToNative();
        this.nativeRunBundleAndSnapshotFromLibrary(this.nativePlatformViewId, prioritizedBundlePaths, entrypointFunctionName, pathToEntrypointFunction, assetManager);
    }

    private native void nativeRunBundleAndSnapshotFromLibrary(long var1, @NonNull String[] var3, @Nullable String var4, @Nullable String var5, @NonNull AssetManager var6);

    @UiThread
    public void dispatchEmptyPlatformMessage(String channel, int responseId) {
        this.ensureAttachedToNative();
        this.nativeDispatchEmptyPlatformMessage(this.nativePlatformViewId, channel, responseId);
    }

    private native void nativeDispatchEmptyPlatformMessage(long var1, String var3, int var4);

    @UiThread
    public void dispatchPlatformMessage(String channel, ByteBuffer message, int position, int responseId) {
        this.ensureAttachedToNative();
        this.nativeDispatchPlatformMessage(this.nativePlatformViewId, channel, message, position, responseId);
    }

    private native void nativeDispatchPlatformMessage(long var1, String var3, ByteBuffer var4, int var5, int var6);

    @UiThread
    public void invokePlatformMessageEmptyResponseCallback(int responseId) {
        this.ensureAttachedToNative();
        this.nativeInvokePlatformMessageEmptyResponseCallback(this.nativePlatformViewId, responseId);
    }

    private native void nativeInvokePlatformMessageEmptyResponseCallback(long var1, int var3);

    @UiThread
    public void invokePlatformMessageResponseCallback(int responseId, ByteBuffer message, int position) {
        this.ensureAttachedToNative();
        this.nativeInvokePlatformMessageResponseCallback(this.nativePlatformViewId, responseId, message, position);
    }

    private native void nativeInvokePlatformMessageResponseCallback(long var1, int var3, ByteBuffer var4, int var5);

    private void onPreEngineRestart() {
        for (FlutterEngine.EngineLifecycleListener listener : this.engineLifecycleListeners) {
            listener.onPreEngineRestart();
        }
    }

    private void ensureNotAttachedToNative() {
        if (this.nativePlatformViewId != null) {
            throw new RuntimeException("Cannot execute operation because FlutterJNI is attached to native.");
        }
    }

    private void ensureAttachedToNative() {
        if (this.nativePlatformViewId == null) {
            throw new RuntimeException("Cannot execute operation because FlutterJNI is not attached to native.");
        }
    }
}

