import numpy as np
import math

MIN_VISIBLE=0.3

def segment_slope(pointa,pointb):
    # 如果某个点的visible概率小于0.3,不计算该线段斜率
    if pointb[2]<MIN_VISIBLE or pointa[2]<MIN_VISIBLE:
        return None
    elif pointb[0]==pointa[0]:
        # 返回无穷大
        return np.Inf
    return (pointb[1]-pointa[1])/(pointb[0]-pointa[0])


def absolute_distance(pointa,pointb):
    # 如果某个点的visible概率小于0.3,不计算亮点之间距离
    if pointb[2]<MIN_VISIBLE or pointa[2]<MIN_VISIBLE:
        return None
    return math.sqrt(((pointa[1]-pointb[1])**2+((pointa[0]-pointb[0])**2)))


def midpoint(pointa,pointb):
    if pointb[2]<MIN_VISIBLE or pointa[2]<MIN_VISIBLE:
        return None
    return ((pointa[0]+pointb[0])/2,(pointa[1]+pointb[1])/2)
