package com.live.cases.apollo;


import com.alibaba.fastjson.JSONObject;
import com.live.cases.largeClassLive.LargeClassLiveTools;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Created by zhangying on  2020/11/28
 */
public class TestJudgeLessonPermission extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("api_judgeLessonPermission") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        super.beforeTest();
    }

    /**
     * 判断是否有备课本权限
     */
    @Test
    public void testJudgeLessonPermission() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("instId","1235115978015883266");
        jsonObject.put("permissionCode",2001);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertEquals("true", jsonBody.getString("success"));
//        Assert.assertEquals("操作成功!", jsonBody.getString("message"));

    }
}
