package com.live.cases.apollo;

import com.alibaba.fastjson.JSONObject;
import com.live.cases.largeClassLive.LargeClassLiveTools;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Created by zhangying on  2020/11/27
 */

public class TestQueryStudentByCourseId extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("api_queryStudentByCourseId") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        super.beforeTest();
    }

    /**
     * 测试通过课次id查询直播学员
     */
    @Test
    public void testQueryStudentByCourseId() {
        LargeClassLiveTools getLargeClassLiveTools = new LargeClassLiveTools();
        JSONObject largeClassLive = getLargeClassLiveTools.getLargeClassLive();
        String liveCourseId= (String) largeClassLive.get("liveCourseId");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);
        jsonObject.put("current",1);
        jsonObject.put("size",3500);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));

    }


}
