package com.live.cases.fileManage.commonFolder;


import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.RandomStringUtil;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetFolderData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.Map;

import static io.restassured.RestAssured.given;
import static org.hamcrest.Matchers.equalTo;

/**
 * Created by zhangying on  2020/11/16
 */

public class TestSaveFolder extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_File) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_saveFolder") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        super.beforeTest();
    }

    /**
     * 测试资料云盘-新增保存文件夹
     */
    @Test
    public void testSaveFolder() {

        String name = "测试文件夹新增"+ RandomStringUtil.randomString(6);  //云盘文件名称
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("createUser", "ADMIN");
        jsonObject.put("disk", "COMMON");
        jsonObject.put("folderTypeEnum", "FOLDER");
        jsonObject.put("instId", "1235115978015883266");
        jsonObject.put("name", name);
        jsonObject.put("parentId", null);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody = "+jsonBody);

        Assert.assertEquals("true", jsonBody.getString("success"));
//        Assert.assertNotEquals(folderName1,folderName);
    }
}

