package com.live.cases.largeClassLive;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Created by zhangying on  2020/02/02
 */

public  class TestGetLargeClassLiveList extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_getLargeClassLiveList") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        super.beforeTest();
    }

    /**
     * 大班直播课列表数据
     */
    @Test
    public void testGetLargeClassLiveList() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("instId","1235115978015883266");
        jsonObject.put("current","1");
        jsonObject.put("size","10");
        System.out.println("jsonObject ="+jsonObject );

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody );

        Assert.assertNotEquals(0, jsonBody.getString("total"));
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));

    }

    /**
     * 大班直播课列表数据-详细查询
     */
    @Test
    public void testGetLargeClassLiveList1() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("instId","1235115978015883266");
        jsonObject.put("current","1");
        jsonObject.put("size","10");
        jsonObject.put("courseName","zy大班直播自动化测试（勿删）");
        jsonObject.put("courseState","FINISH");
        jsonObject.put("endTime","1612281599999");
        jsonObject.put("startTime","1612108800000");
        jsonObject.put("teacherId","1235115979473997826");
        jsonObject.put("teacherName","主账户老师");

        System.out.println("jsonObject ="+jsonObject );

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody );

        Assert.assertEquals("1", jsonBody.getJSONObject("result").getString("total"));
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));

    }

}
