package com.live.cases.musicPlay;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetOnlyOneClassLiveListData;
import com.live.xmutils.GetOnlyOneCourseData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Created by zhangying on  2021/1/30
 */

public class TestDelOnlyOneClassLive extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_delCourse") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        super.beforeTest();
        System.out.println(xmAppApi);
    }

    /**
     * 测试删除乐器陪练课
     */
    @Test
    public void testDelOnlyOneClassLive() {
        GetOnlyOneCourseData getOnlyOneCourseData=new GetOnlyOneCourseData();
        JSONObject onlyOneClassCourse = getOnlyOneCourseData.getOnlyOneCourseList();

        JSONObject liveCourse = onlyOneClassCourse.getJSONObject("result").getJSONArray("records").getJSONObject(0);
        String liveCourseId = (String) liveCourse.get("liveCourseId");
        if (liveCourseId == null){
            onlyOneClassCourse = getOnlyOneCourseData.creatOnlyOneCourse();
            liveCourseId = (String) onlyOneClassCourse.get("liveCourseId");
        }
        System.out.println("liveCourseId ="+liveCourseId);

        GetOnlyOneClassLiveListData getOnlyOneClassLiveListData = new GetOnlyOneClassLiveListData();
        JSONObject liveList = getOnlyOneClassLiveListData.getOnlyOneClassLiveList() ;
        JSONObject liveCourseData = liveList.getJSONObject("result").getJSONArray("records").getJSONObject(0);
        String courseName = (String) liveCourseData.get("courseName");
        System.out.println("courseName ="+courseName);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);

        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        JSONObject liveList1 = getOnlyOneClassLiveListData.getOnlyOneClassLiveList() ;
        JSONObject liveCourseData1 = liveList1.getJSONObject("result").getJSONArray("records").getJSONObject(0);
        String courseName1 = (String) liveCourseData1.get("courseName");
        System.out.println("courseName ="+courseName);

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));
        Assert.assertNotEquals(courseName, courseName1);

    }


}
