/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomai.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.ApiResult;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.client.OkHttpClient;
import com.xiaomai.client.RestfulClient;
import com.xiaomai.client.SSLRestfulClient;
import com.xiaomai.client.UtDal;
import com.xiaomai.client.XMAppApi;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.CommonLogin;
import com.xiaomai.utils.CommonLoginInfo;
import com.xiaomai.utils.CommonRequestParameters;
import com.xiaomai.utils.JsonAndFile;
import com.xiaomai.utils.SpringContextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Properties;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.springframework.util.StringUtils;
import org.testng.Assert;
import org.testng.ITestResult;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

@ContextConfiguration(locations={"classpath:/spring-core.xml"})
public class ApiTest
extends AbstractTestNGSpringContextTests {
    public static RestfulClient httpclient = null;
    public static SSLRestfulClient sslhttpclient = null;
    public static OkHttpClient okHttpClient = null;
    private static String host = null;
    private static String url = null;
    private Properties prop = null;
    public static UtDal dal = new UtDal();
    private static CommonRequestParameters loginInfo;
    private ApiResult apiResult = new ApiResult();

    @BeforeClass
    public static void beforeClass() {
        httpclient = new RestfulClient();
        sslhttpclient = new SSLRestfulClient();
        okHttpClient = new OkHttpClient();
    }

    @BeforeMethod
    public void beforeTest() {
    }

    public void initApi(XMAppApi xmAppApi) {
        this.clearApiData(xmAppApi);
        this.dataPreparation(xmAppApi);
    }

    private void clearApiData(XMAppApi api) {
        api.setApi_request_params(new IdentityHashMap<String, String>());
        api.setApi_request_data(null);
        api.setApi_request_headers(new HashMap<String, String>());
        api.setApi_response(null);
        api.setApi_traceId(null);
    }

    public void beforeDataRequest(XMAppApi dataApi, DataUserInfo ... userInfos) {
        this.clearApiData(dataApi);
        if (userInfos.length > 0) {
            DataUserInfo info = userInfos[0];
            Assert.assertNotNull((Object)info, (String)"userInfos \u4e3a\u7a7a\uff01\uff01\uff01");
            if (!StringUtils.isEmpty((Object)info.getLoginUser())) {
                dataApi.setLoginUser(info.getLoginUser());
            }
            if (!StringUtils.isEmpty((Object)info.getTerminal())) {
                dataApi.setTerminal(info.getTerminal());
            }
        }
        this.dataPreparation(dataApi);
    }

    private void dataPreparation(XMAppApi executionApi) {
        Assert.assertNotNull((Object)executionApi.getApiModule(), (String)"\u5fc5\u8981\u7684api\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        this.prop = CommUtil.getconfig();
        JsonAndFile fileHandle = new JsonAndFile();
        String apiModule = this.prop.getProperty(executionApi.getApiModule());
        String fileParam = JsonAndFile.readTxtFile(System.getProperty("user.dir") + apiModule);
        Assert.assertNotNull((Object)fileParam, (String)"\u5fc5\u8981\u7684API\u6a21\u5757\u4fe1\u606f\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5api\u6a21\u5757\u6587\u4ef6\u8def\u5f84\uff01");
        JSONObject api = (JSONObject)JSON.parseObject((String)fileParam).get((Object)executionApi.getApiName());
        Assert.assertNotNull((Object)api, (String)"\u5fc5\u8981\u7684API\u63a5\u53e3\u4fe1\u606f\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5apiName\u4fe1\u606f\uff01");
        executionApi.setApiDesc(api.getString("apiName"));
        String env = "rc";
        if (!StringUtils.isEmpty((Object)executionApi.getEnv())) {
            env = executionApi.getEnv();
        }
        host = this.prop.getProperty(env);
        CommonLoginInfo loginInfoMap = (CommonLoginInfo)SpringContextUtil.getBean("commonLoginInfoMap");
        loginInfo = loginInfoMap.get(executionApi.getLoginUser());
        if (StringUtils.isEmpty((Object)loginInfo.getToken())) {
            CommonLogin common_login = new CommonLogin();
            common_login.login(env, executionApi.getLoginUser(), executionApi.getTerminal());
            loginInfo = loginInfoMap.get(executionApi.getLoginUser());
        }
        url = host + api.getString("apiPath") + loginInfo.getCommonParam(executionApi.getTerminal());
        executionApi.setUrl(url);
        if ("B".equals(executionApi.getTerminal())) {
            executionApi.getHeadrs().put("instid", loginInfo.getInstId());
            executionApi.getHeadrs().put("bizAccountId", loginInfo.getAid());
            executionApi.getHeadrs().put("xmversion", "5.0");
            executionApi.getHeadrs().put("vn", "5.4.0");
        } else if ("M".equals(executionApi.getTerminal())) {
            executionApi.getHeadrs().put("usertype", loginInfo.getUserType());
            executionApi.getHeadrs().put("deptpath", loginInfo.getDeptpath());
        }
        executionApi.getHeadrs().put("xm_request_source", "test");
        executionApi.getHeadrs().put("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36");
        executionApi.getHeadrs().put("Accept", "*/*");
        executionApi.getHeadrs().put("Connection", "Keep-Alive");
        if (api.containsKey((Object)"apiContentType") || StringUtils.isEmpty((Object)api.getString("apiContentType"))) {
            executionApi.getHeadrs().put("Content-type", "application/json;charset=utf-8");
        } else {
            executionApi.getHeadrs().put("Content-type", api.getString("apiContentType"));
        }
    }

    public XMAppApi doRequest(XMAppApi xmAppApi, String requestType) {
        OkHttpClient okHttpClient = new OkHttpClient();
        switch (requestType) {
            case "JSON": {
                okHttpClient.doPostRequest(xmAppApi.getUrl(), xmAppApi.getDataJson(), xmAppApi.getHeadrs());
                break;
            }
            case "PARAM": {
                okHttpClient.doPostRequest(xmAppApi.getUrl(), xmAppApi.getParams(), xmAppApi.getHeadrs());
                break;
            }
            case "FORM": {
                okHttpClient.doPostForForm(xmAppApi.getUrl(), xmAppApi.getParams(), xmAppApi.getHeadrs());
                break;
            }
            case "GET": {
                okHttpClient.doGetRequest(xmAppApi.getUrl(), xmAppApi.getParams(), xmAppApi.getHeadrs());
            }
        }
        HashMap<String, String> head = okHttpClient.getHeaders();
        String response = okHttpClient.getBody();
        xmAppApi.setApi_response(response);
        xmAppApi.setApi_traceId((String)head.get("traceId"));
        xmAppApi.setApi_request_data(xmAppApi.getDataJson());
        xmAppApi.setApi_request_params(xmAppApi.getParams());
        xmAppApi.setApi_request_headers(head);
        this.apiResult.setApi_response(response);
        this.apiResult.setApi_traceId((String)head.get("traceId"));
        this.apiResult.setApi_request_data(xmAppApi.getDataJson());
        this.apiResult.setApi_request_params(xmAppApi.getParams());
        this.apiResult.setApi_request_headers(head);
        return xmAppApi;
    }

    @AfterMethod
    public void afterMethod(ITestResult result) {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("Host", this.apiResult.getUrl()));
        params.add(new BasicNameValuePair("traceId", this.apiResult.getApi_traceId()));
        params.add(new BasicNameValuePair("RequestParams", this.apiResult.getApi_request_params().toString()));
        params.add(new BasicNameValuePair("RequestData", this.apiResult.getApi_request_data()));
        params.add(new BasicNameValuePair("Response", this.apiResult.getApi_response()));
        result.setParameters(params.toArray());
        result.setAttribute("ApiDesc", (Object)this.apiResult.getApiDesc());
    }

    @AfterClass
    public static void afterClass() {
        httpclient.shutDownConnection();
        sslhttpclient.shutDownConnection();
    }
}

