package com.live.cases.seriesCourse;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.RandomStringUtil;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetSeriesCourseData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author fym
 * @date 2021/2/19 4:20 下午
 */
public class TestSeriesPage extends XMBaseTest {


    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_Series) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_seriesPage") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("樊圆梦");
        super.beforeTest();
    }

    @Test
    public void testSeriesPage(){

        Map bodyMap = new HashMap();

        bodyMap.put("teacherId","");
        bodyMap.put("current",1);
        bodyMap.put("instId",xmAppApi.getLoginInfo().getInstId());
        bodyMap.put("size",10);
        bodyMap.put("createTimeBegin","");
        bodyMap.put("createTimeEnd","");
        bodyMap.put("seriesName","");


        System.out.println("bodyMap = "+bodyMap);

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();
        System.out.println("bodyData  = "+bodyData);

        xmAppApi.doRequest(RequestType.JSON, params,bodyData, headers);
        System.out.println(xmAppApi);

        JSONObject seriesPage = xmAppApi.getBodyInJSON();

        System.out.println("seriesPage  ="+seriesPage);

        Assert.assertEquals("true", seriesPage.getString("success"));
        Assert.assertEquals("200", seriesPage.getString("code"));
        Assert.assertEquals("操作成功!", seriesPage.getString("message"));


//        JSONObject jsonObject = new JSONObject();
//        jsonObject.put("teacherId","");
//        jsonObject.put("current",1);
//        jsonObject.put("instId",xmAppApi.getLoginInfo().getInstId());
//        jsonObject.put("size",10);
//        jsonObject.put("createTimeBegin","");
//        jsonObject.put("createTimeEnd","");
//        jsonObject.put("seriesName","");
//
//
//        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
//        System.out.println(xmAppApi);
//        JSONObject jsonBody = xmAppApi.getBodyInJSON();
//        System.out.println("jsonBody ="+jsonBody );

    }
}
