package com.live.cases.videoCourse;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.RandomStringUtil;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetVideoClassData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
* fym
* 2021-02-07
* */

public class TestCreateLesson extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_B) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_createLesson") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("樊圆梦");
        super.beforeTest();
    }

    //创建任何学员通过链接加入学习视频课
    @Test
    public void testCreateLesson(){

        String scheduleName = RandomStringUtil.randomNumber(20,"VideoClass_");

        List studentIds = new ArrayList();
        studentIds.add("");

        Map picMap = new HashMap();
        picMap.put("size",1791124);
        picMap.put("mediaName","微信截图_20190122110413.png");
        picMap.put("mediaContent","1358261654633242626");
        picMap.put("mediaType","PICTURE");
        picMap.put("mediaUrl","blob:https://b.xiaomai5.com/6f8def48-3cc5-4b6b-8266-615ca9129523");

        Map textMap = new HashMap();
        textMap.put("mediaType","TEXT");
        textMap.put("mediaContent","<p>这是视频课简介</p>");
        textMap.put("key","XeaxxDS5NmSfjEpp");
        textMap.put("mediaContentLength",7);


        List scheduleMedia = new ArrayList();
        scheduleMedia.add(picMap);
        scheduleMedia.add(textMap);


        Map bodyMap = new HashMap();
        bodyMap.put("size",16341066);
        bodyMap.put("instId",xmAppApi.getLoginInfo().getInstId());
        bodyMap.put("videoName","胖胖的你悠然自得.mp4");
        bodyMap.put("videoDuration",30.808644);
        bodyMap.put("scheduleName",scheduleName);
        bodyMap.put("scheduleVideoId","1357973439543160834");
        bodyMap.put("joinType","ALL");
        bodyMap.put("teacherId","1303609085537103873");
        bodyMap.put("scheduleMedia",scheduleMedia);
        bodyMap.put("studentIds",studentIds);

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        xmAppApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(xmAppApi);
        com.alibaba.fastjson.JSONObject jsonBody = xmAppApi.getBodyInJSON();

        GetVideoClassData getVideoClassData = new GetVideoClassData();
        JSONObject jsonObject1 = getVideoClassData.VideoClassData();
        String id = jsonObject1.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        Assert.assertEquals(jsonBody.getString("result"),id);

        getVideoClassData.removeLessonSchedule(id);


    }





}
