package com.live.xmutils;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.RandomStringUtil;
import com.live.utils.XMBaseTest;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @author fym
 * @date 2021/2/6 6:31 下午
 */
public class GetVideoClassData extends XMBaseTest {

    //查询视频课次列表
    public JSONObject VideoClassData(){

        dataApi.setApiModule(ApiModele.CloudClass_B) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_lessonScheduleListPage") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）

        super.beforeDataRequest();
        System.out.println("查询列表========"+dataApi);

        Map bodyMap = new HashMap();
        bodyMap.put("current",1);
        bodyMap.put("instId",dataApi.getLoginInfo().getInstId());
        bodyMap.put("size",10);

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        dataApi.doRequest(RequestType.JSON, params,bodyData, headers);

        JSONObject jsonBody = dataApi.getBodyInJSON();

        return jsonBody;

    }

    //创建视频课（任何人）
    public String createVideoClass() throws InterruptedException {

        dataApi.setApiModule(ApiModele.CloudClass_B) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_createLesson") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）

        super.beforeDataRequest();

        String scheduleName = RandomStringUtil.randomNumber(20,"VideoClass");

        List studentIds = new ArrayList();
        studentIds.add("");

        Map picMap = new HashMap();
        picMap.put("size",1791124);
        picMap.put("mediaName","微信截图_20190122110413.png");
        picMap.put("mediaContent","1358261654633242626");
        picMap.put("mediaType","PICTURE");
        picMap.put("mediaUrl","blob:https://b.xiaomai5.com/6f8def48-3cc5-4b6b-8266-615ca9129523");

        Map textMap = new HashMap();
        textMap.put("mediaType","TEXT");
        textMap.put("mediaContent","<p>这是视频课简介</p>");
        textMap.put("key","XeaxxDS5NmSfjEpp");
        textMap.put("mediaContentLength",7);


        List scheduleMedia = new ArrayList();
        scheduleMedia.add(picMap);
        scheduleMedia.add(textMap);


        Map bodyMap = new HashMap();
        bodyMap.put("size",16341066);
        bodyMap.put("instId",dataApi.getLoginInfo().getInstId());
        bodyMap.put("videoName","胖胖的你悠然自得.mp4");
        bodyMap.put("videoDuration",30.808644);
        bodyMap.put("scheduleName",scheduleName);
        bodyMap.put("scheduleVideoId","1357973439543160834");
        bodyMap.put("joinType","ALL");
        bodyMap.put("teacherId","1303609085537103873");
        bodyMap.put("scheduleMedia",scheduleMedia);
        bodyMap.put("studentIds",studentIds);

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        dataApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(dataApi);
        com.alibaba.fastjson.JSONObject jsonBody = dataApi.getBodyInJSON();

        TimeUnit.SECONDS.sleep(3);
        String scheduleId = jsonBody.getString("result");
        return scheduleId;


    }

    //查询课次详情
    public JSONObject classDetail() throws InterruptedException {

        String scheduleId = createVideoClass();

        dataApi.setApiModule(ApiModele.CloudClass_Video) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_getLessonScheduleDetail") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）

        super.beforeDataRequest();


        Map bodyMap = new HashMap();
        bodyMap.put("scheduleId",scheduleId);

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        dataApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(dataApi);
        com.alibaba.fastjson.JSONObject jsonBody = dataApi.getBodyInJSON();

        return jsonBody;



    }

    //添加视频课学员
    public String addLessonScheduleStu() throws InterruptedException {

        String scheduleId = createVideoClass();

        dataApi.setApiModule(ApiModele.CloudClass_Video) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_addLessonScheduleStu") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）

        super.beforeDataRequest();



        List studentIds = new ArrayList();
        studentIds.add("1308376918943268866");

        Map bodyMap = new HashMap();
        bodyMap.put("instId",dataApi.getLoginInfo().getInstId());
        bodyMap.put("scheduleId",scheduleId);
        bodyMap.put("studentIds",studentIds);

        org.json.JSONObject jsonObject = new org.json.JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        dataApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(dataApi);
        JSONObject jsonBody0 = dataApi.getBodyInJSON();
        System.out.println(jsonBody0);

        return scheduleId;

    }
    //删除视频课
    public void removeLessonSchedule(String scheduleId){

        dataApi.setApiModule(ApiModele.CloudClass_Video) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_removeLessonSchedule") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）

        super.beforeDataRequest();


        Map bodyMap = new HashMap();
        bodyMap.put("scheduleId",scheduleId);

        org.json.JSONObject jsonObject = new org.json.JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        dataApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(dataApi);
        JSONObject jsonBody0 = dataApi.getBodyInJSON();
        System.out.println(jsonBody0);

    }















}
