package com.live.cases.fileManage.commonFolder;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;


/**
 * @Description 文件列表，公共文件
 * @author zhangyumeng
 */

public class TestCommonFolderList extends XMBaseTest {

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModele.CloudClass_B )
                .setApiName("API_commonFolderList")
                .setLoginUser("zhangy-b")  //张莹的账号下数据比较多
                .setTerminal(Terminal.B);
        dal.setCase_owner("张莹/张雨朦");

        super.beforeTest();
    }

    @Test(description = "获取公共文件列表")
    public void testCommonFolderList(){
        JSONObject jsonObject = new JSONObject();
        //jsonObject.put("bizAccountId","1323235986786807809");
        jsonObject.put("current",1);
        jsonObject.put("disk", "COMMON");
        jsonObject.put("folderIdType", "FOLDER");
        jsonObject.put("instId",xmAppApi.getLoginInfo().getInstId());
        jsonObject.put("searchName", null);
        jsonObject.put("size", 10);
        System.out.println("请求" + jsonObject);

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers);

        JSONObject responseRes = xmAppApi.getBodyInJSON();
        Assert.assertEquals("true",responseRes.getString("success"));
    }

    @Test(description = "公共文件列表，按名称排序")
    public void testCommonFolderList1(){
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current",1);
        jsonObject.put("disk", "COMMON");
        jsonObject.put("folderIdType", "FOLDER");
        jsonObject.put("instId",xmAppApi.getLoginInfo().getInstId());
        jsonObject.put("searchName", null);
        jsonObject.put("size", 10);
        jsonObject.put("sort", "NAME_DESC");
        jsonObject.put("parentId", null);
        System.out.println("请求" + jsonObject);

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers);
        JSONObject responseRes = xmAppApi.getBodyInJSON();
        System.out.println("responseRes =="+responseRes );

        Assert.assertEquals("true",responseRes.getString("success"));
        Assert.assertNotNull(responseRes.getJSONObject("result").getString("total"));
    }
}
