package com.live.cases.liveAssets;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Created by zhangying on  2020/02/01
 */

public class TestOrderPage extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_B) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_liveAssets/orderPage") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
        System.out.println(xmAppApi);
    }

    /**
     * 测试账户管理-订单列表
     */
    @Test
    public void testOrderPage() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current",1);
        jsonObject.put("size",10);
        jsonObject.put("instId","1235115978015883266");
        jsonObject.put("sort","DEFAULT");

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertEquals("2", jsonBody.getJSONObject("result").getString("total"));
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));

    }

}
