package com.live.cases.liveClientT.musicPlay;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;


/**
 * @author zhangying
 * @date 2021/2/25 16:50
 */
public class TestGetCourseDay extends XMBaseTest {
    @BeforeMethod
    public void beforeTest()  {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_getCourseDay") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
    }

    /**
     * 测试乐器陪练课获取当日课表
     */
    @Test
    public void testGetCourseDay() {

        List arrayList = new ArrayList();
        arrayList.add("SMALL_CLASS_ONLY_ONE");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tenantId",xmAppApi.getLoginInfo().getInstId());
        jsonObject.put("liveType",arrayList);
        jsonObject.put("startTime","1614182400000");
        jsonObject.put("endTime","1614527999000");
        jsonObject.put("teacherId",xmAppApi.getLoginInfo().getTid());

        System.out.println("jsonObject == "+jsonObject);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));

    }
}
