package com.live.cases.apollo;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.Map;

/**
 * @author NHX-->zym
 * @Function B端直播课 获取用户磁盘
 * @Date 2020/11/21 20:11
 */
public class TestGetUserDisk_B extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_File) // API 所属模块
                .setApiName("API_getGetUserDisk") // API 名称
                .setLoginUser("zhangYuM_b")         // http 接口，测试账号
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）


        dal.setCase_owner("zym")
                .setCase_name("B端直播课 获取用户磁盘：" + Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);

        super.beforeTest();
    }

    @Test(description = "B端直播课 获取用户磁盘")
    public void testGetUserDisk(){


        Map<String,Object> bodyMap = new HashMap<>();

        JSONObject jsonBody = new JSONObject(bodyMap);
        String data = jsonBody.toJSONString();

        System.out.println("请求参数==========="+data);

        xmAppApi.doRequest(RequestType.JSON, params, data, headers);
        JSONObject jsonResponseBody = xmAppApi.getBodyInJSON();
        Assert.assertEquals(jsonResponseBody.getString("success"), "true", "操作成功!");


    }

}
