package com.live.cases.largeClassLive;

import com.alibaba.fastjson.JSONObject;
import com.live.client.DataUserInfo;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.RandomStringUtil;
import com.live.utils.XMBaseTest;

/**
 * 直播工具类
 *
 * @author xue.w
 * @since 2020/11/16 at  3:54 下午
 **/
public class LargeClassLiveTools extends XMBaseTest {
    //获取大班直播，无则新增
    public JSONObject getLargeClassLive(DataUserInfo... userInfo) {
        dataApi.setApiModule(ApiModele.CloudClass_B)
                .setApiName("API_getLargeClassLiveList")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);

        dataApi.doRequest(RequestType.JSON,params, "", dataheadrs);

        if (dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("records").size() >0) {
            return dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("records").getJSONObject(0);
        }

        return createLargeClassLive(userInfo);
    }

    //新建大班直播
    public JSONObject createLargeClassLive(DataUserInfo... userInfo) {
        dataApi.setApiModule(ApiModele.CloudClass_B)
                .setApiName("API_createLargeClassLive")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);

        dataApi.doRequest(RequestType.JSON, params, buildCreateLargeClassLiveParam().toJSONString(), dataheadrs);

        return getLargeClassLive(userInfo);
    }

    //组装大班直播新增的数据
    public JSONObject buildCreateLargeClassLiveParam() {
        JSONObject largeClassLive = new JSONObject();
        largeClassLive.put("courseName", RandomStringUtil.randomNumber(14, "live_course_"));
        largeClassLive.put("teacherId",xmAppApi.getLoginInfo().getTid());
        largeClassLive.put("startTime",System.currentTimeMillis() + 60 * 1000);
        largeClassLive.put("endTime",System.currentTimeMillis() + 30 * 60 * 1000);
        largeClassLive.put("needRecord","YES");
        largeClassLive.put("liveType","LARGE_CLASS_LIVE");
        largeClassLive.put("consumeHourNum",1);
        largeClassLive.put("consumeClassTime","1");

        return largeClassLive;
    }
}
