package com.live.cases.videoClass;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetVideoClassData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import sun.awt.X11FontManager;

import java.util.HashMap;
import java.util.Map;

/**
 * @author fym
 * @date 2021/2/8 11:53 上午
 */
public class TestGetLessonScheduleDetail extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_Video) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_getLessonScheduleDetail") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("樊圆梦");
        super.beforeTest();
    }

    @Test
    public void testGetLessonScheduleDetail(){

        GetVideoClassData getVideoClassData = new GetVideoClassData();
        String scheduleId = getVideoClassData.createVideoClass();

        Map bodyMap = new HashMap();
        bodyMap.put("scheduleId",scheduleId);

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        xmAppApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(xmAppApi);
        com.alibaba.fastjson.JSONObject jsonBody = xmAppApi.getBodyInJSON();

        JSONObject jsonObject1 = getVideoClassData.VideoClassData();
        String scheduleId0 = jsonObject1.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        Assert.assertEquals(scheduleId0,jsonBody.getJSONObject("result").getString("id"));//与列表第一个视频课id比对

    }

}
