package com.live.cases.myClassAPP;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetDayTime;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @author zhangying
 * @date 2021/3/3 3:30 下午
 */
public class TestQueryStudentCourse extends XMBaseTest {
    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_customerLive) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_queryStudentCourse") // API 名称  必传
                .setLoginUser("zhangy-APPC")         // http 接口，测试账号 必传
                .setTerminal(Terminal.APP_C);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("zhangying");
        super.beforeTest();
        System.out.println(xmAppApi);
    }

    /**
     * 测试C端判断云课堂账户余额的接口
     */
    @Test
    public void testQueryStudentCourse() {
        GetDayTime getDayTime = new GetDayTime();
        long zeroTime = getDayTime.getDayZeroTime();

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("startTime",zeroTime);
        jsonObject.put("endTime",zeroTime+24*60*60*1000-1000);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody =="+jsonBody);

        Assert.assertEquals("操作成功!", jsonBody.getString("message"));
        Assert.assertEquals("200", jsonBody.getString("code"));
        Assert.assertEquals("true", jsonBody.getString("success"));
    }
}
