package com.live.cases.videoCourse;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetVideoClassData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author fym
 * @date 2021/2/19 1:52 下午
 */
public class TestAddLessonScheduleStu extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_Video) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_addLessonScheduleStu") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("樊圆梦");
        super.beforeTest();
    }


    @Test
    public void AddLessonScheduleSt() throws InterruptedException {
        GetVideoClassData getVideoClassData = new GetVideoClassData();
        String scheduleId = getVideoClassData.createVideoClass();


        List studentIds = new ArrayList();
        studentIds.add("1308376918943268866");

        Map bodyMap = new HashMap();
        bodyMap.put("instId",xmAppApi.getLoginInfo().getInstId());
        bodyMap.put("scheduleId",scheduleId);
        bodyMap.put("studentIds",studentIds);

        org.json.JSONObject jsonObject = new org.json.JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        xmAppApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody0 = xmAppApi.getBodyInJSON();
        System.out.println(jsonBody0);

        Assert.assertEquals("1",getVideoClassData.VideoClassData().getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("stuNum"));


    }


}
