package com.live.cases.saasTeacher;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetLiveCourseData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @author zhangying
 * @date 2021/3/5 4:40 下午
 */
public class TestCourseLaunch extends XMBaseTest {
    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_courseLaunch") // API 名称  必传
                .setLoginUser("zhangy-T")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
    }

    @Test(description = "启动欢拓直播客户端")
    public void testCourseLaunch() throws InterruptedException {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId","1333692400423833602");

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
        JSONObject jsonbody = xmAppApi.getBodyInJSON();

        System.out.println("jsonbody  =="+jsonbody);

        Assert.assertEquals("true",jsonbody.getString("success"));
        Assert.assertNotNull(jsonbody.getJSONObject("result").getString("protocol"));
    }

}
