package com.live.cases.interactionLive;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Created by zhangying on  2020/02/03
 */

public  class TestGetLiveCourseRecordInfos extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_getLiveCourseRecordInfos") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        super.beforeTest();
        System.out.println(xmAppApi);
    }

    /**
     * 大班互动-查看直播回放
     */
    @Test
    public void testGetLiveCourseRecordInfos() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId","1356798987214893057");

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("courseName ="+jsonBody);
        System.out.println("courseName ="+jsonBody.getJSONObject("result").getString("liveCourseId"));

        Assert.assertEquals(jsonBody.getJSONObject("result").getString("liveCourseId"),"1356798987214893057");
        Assert.assertEquals(jsonBody.getJSONObject("result").getString("recordGenerate"), "true");
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));

    }

}
