package com.live.cases.largeClassLive;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Created by zhangying on  2020/02/03
 */

public  class TestGetClassReport extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_B) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_getClassReport") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        super.beforeTest();
    }

    /**
     * 大班直播-老师课堂报告
     */
    @Test
    public void testGetClassReport() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("courseId","1356196461296828418");
        System.out.println("jsonObject ="+jsonObject );

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("courseName ="+jsonBody.getJSONObject("result"));

//        Assert.assertNotEquals(jsonBody.getJSONObject("result").getJSONArray("visitorInfoVOList").size(), 0);
        Assert.assertEquals(jsonBody.getJSONObject("result").getString("courseName"),"zy直播测试1" );
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));

    }

}
